/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.jdbc.entity.NavigationEntity;
import org.exoplatform.portal.jdbc.entity.NodeEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.mop.NodeTarget;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.dao.NavigationDAO;
import org.exoplatform.portal.mop.dao.NodeDAO;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.portal.mop.storage.NavigationStorage;

public class NavigationStorageImpl
implements NavigationStorage {
    private DescriptionStorage descriptionStorage;
    private NavigationDAO navigationDAO;
    private SiteDAO siteDAO;
    private NodeDAO nodeDAO;
    private PageDAO pageDAO;

    public NavigationStorageImpl(DescriptionStorage descriptionStorage, NavigationDAO navigationDAO, SiteDAO siteDAO, NodeDAO nodeDAO, PageDAO pageDAO) {
        this.descriptionStorage = descriptionStorage;
        this.navigationDAO = navigationDAO;
        this.siteDAO = siteDAO;
        this.nodeDAO = nodeDAO;
        this.pageDAO = pageDAO;
    }

    public NodeData loadNode(Long nodeId) {
        NodeEntity node = (NodeEntity)this.nodeDAO.find(nodeId);
        return this.buildNodeData(node);
    }

    public NodeData[] loadNodes(String pageRef) {
        PageEntity page = this.pageDAO.findByKey(PageKey.parse((String)pageRef));
        if (page == null) {
            return new NodeData[0];
        }
        List<NodeEntity> nodes = this.nodeDAO.findAllByPage(page.getId());
        NodeData[] result = new NodeData[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            result[i] = this.buildNodeData(nodes.get(i));
        }
        return result;
    }

    public NodeData[] createNode(Long parentId, Long previousId, String name, NodeState state, Integer index) {
        NodeEntity parent = null;
        if (parentId != null) {
            parent = (NodeEntity)this.nodeDAO.find(parentId);
        }
        Long prev = null;
        if (previousId != null) {
            prev = previousId;
        }
        NodeEntity target = new NodeEntity();
        this.buildNodeEntity(target, state);
        target.setName(name);
        target.setParent(parent);
        if (parent != null) {
            List<NodeEntity> children = parent.getChildren();
            if (prev == null && index != null && index < children.size() && index >= 0) {
                children.add(index, target);
            } else {
                int i;
                for (i = 0; i < children.size(); ++i) {
                    if (!children.get(i).getId().equals(prev)) continue;
                    ++i;
                    break;
                }
                children.add(i, target);
            }
            parent.setChildren(children);
            parent.setUpdatedDate(System.currentTimeMillis());
            target = (NodeEntity)this.nodeDAO.create(target);
            parent = (NodeEntity)this.nodeDAO.update(parent);
        } else {
            target = (NodeEntity)this.nodeDAO.create(target);
        }
        return new NodeData[]{this.buildNodeData(parent), this.buildNodeData(target)};
    }

    public NodeData destroyNode(Long targetId) {
        NodeEntity node = (NodeEntity)this.nodeDAO.find(targetId);
        if (node != null) {
            NodeEntity parent = node.getParent();
            if (parent != null) {
                Iterator<NodeEntity> children = parent.getChildren().iterator();
                while (children.hasNext()) {
                    if (!children.next().getId().equals(node.getId())) continue;
                    children.remove();
                    break;
                }
            }
            this.nodeDAO.delete(node);
            return this.buildNodeData(parent);
        }
        return null;
    }

    public NodeData updateNode(Long targetId, NodeState state) {
        NodeEntity node = (NodeEntity)this.nodeDAO.find(targetId);
        if (node != null) {
            this.buildNodeEntity(node, state);
            node = (NodeEntity)this.nodeDAO.update(node);
            return this.buildNodeData(node);
        }
        return null;
    }

    public NodeData[] moveNode(Long targetId, Long fromId, Long toId, Long previousId) {
        List<NodeEntity> children;
        NodeEntity target = (NodeEntity)this.nodeDAO.find(targetId);
        if (target == null) {
            return new NodeData[0];
        }
        NodeEntity from = null;
        if (fromId != null && (from = (NodeEntity)this.nodeDAO.find(fromId)) != null) {
            List<NodeEntity> children2 = from.getChildren();
            children2.remove(target);
        }
        int index = -1;
        NodeEntity to = null;
        if (toId != null && (children = (to = (NodeEntity)this.nodeDAO.find(toId)).getChildren()) != null && previousId != null) {
            Long prev = previousId;
            for (index = 0; index < children.size() && !children.get(index).getId().equals(prev); ++index) {
            }
        }
        target.setParent(to);
        if (to != null) {
            children = to.getChildren();
            index = index >= children.size() ? children.size() : ++index;
            children.add(index, target);
            to.setChildren(children);
            to.setUpdatedDate(System.currentTimeMillis());
            to = (NodeEntity)this.nodeDAO.update(to);
        }
        target.setUpdatedDate(System.currentTimeMillis());
        target = (NodeEntity)this.nodeDAO.update(target);
        if (from != null && !Objects.equals(fromId, toId)) {
            from.setUpdatedDate(System.currentTimeMillis());
            from = (NodeEntity)this.nodeDAO.update(from);
        }
        return new NodeData[]{this.buildNodeData(target), this.buildNodeData(from), this.buildNodeData(to)};
    }

    public NodeData[] renameNode(Long targetId, Long parentId, String name) {
        NodeEntity target = (NodeEntity)this.nodeDAO.find(targetId);
        if (target == null) {
            return new NodeData[0];
        }
        NodeEntity parent = null;
        if (parentId != null) {
            parent = (NodeEntity)this.nodeDAO.find(parentId);
        }
        target.setName(name);
        target.setUpdatedDate(System.currentTimeMillis());
        this.nodeDAO.update(target);
        return new NodeData[]{this.buildNodeData(target), this.buildNodeData(parent)};
    }

    public NavigationData loadNavigationData(SiteKey key) {
        NavigationEntity navEntity = this.navigationDAO.findByOwner(key.getType(), key.getName());
        if (navEntity != null) {
            NavigationState navigationState = new NavigationState(Integer.valueOf(navEntity.getPriority()));
            return new NavigationData(key, navigationState, String.valueOf(navEntity.getRootNode().getId()));
        }
        return null;
    }

    private NodeEntity getRootNode(Long nodeId) {
        NodeEntity entity = (NodeEntity)this.nodeDAO.find(nodeId);
        if (entity != null && entity.getParent() != null && entity.getParent().getId().longValue() != entity.getId().longValue()) {
            return this.getRootNode(entity.getParent().getId());
        }
        return entity;
    }

    public void saveNavigation(SiteKey key, NavigationState state) {
        NavigationEntity navEntity = this.navigationDAO.findByOwner(key.getType(), key.getName());
        if ((navEntity = this.buildNavEntity(navEntity, key, state.getPriority())).getId() == null) {
            this.nodeDAO.create(navEntity.getRootNode());
            this.navigationDAO.create(navEntity);
        } else {
            this.navigationDAO.update(navEntity);
        }
    }

    public boolean destroyNavigation(NavigationData data) {
        SiteKey siteKey = data.getSiteKey();
        NavigationEntity navEntity = this.navigationDAO.findByOwner(siteKey.getType(), siteKey.getName());
        if (navEntity != null) {
            this.removeDescriptions(navEntity.getRootNode());
            this.navigationDAO.delete(navEntity);
            return true;
        }
        return false;
    }

    public boolean destroyNavigation(SiteKey siteKey) {
        NavigationData navigationData = this.loadNavigationData(siteKey);
        if (navigationData == null) {
            return false;
        }
        return this.destroyNavigation(navigationData);
    }

    private NavigationEntity buildNavEntity(NavigationEntity entity, SiteKey key, Integer priority) {
        if (entity == null) {
            entity = new NavigationEntity();
            NodeEntity rootNode = new NodeEntity();
            rootNode.setName("default");
            rootNode.setTarget(NodeTarget.SAME_TAB);
            rootNode.setUpdatedDate(System.currentTimeMillis());
            entity.setRootNode(rootNode);
        }
        entity.setPriority(priority == null ? 0 : priority);
        entity.setOwner(this.siteDAO.findByKey(key));
        return entity;
    }

    private void buildNodeEntity(NodeEntity entity, NodeState state) {
        if (state == null) {
            return;
        }
        entity.setEndTime(state.getEndPublicationTime());
        entity.setIcon(state.getIcon());
        entity.setLabel(state.getLabel());
        if (state.getPageRef() != null) {
            PageEntity page = this.pageDAO.findByKey(state.getPageRef());
            if (page != null) {
                entity.setPage(page);
            }
        } else {
            entity.setPage(null);
        }
        entity.setStartTime(state.getStartPublicationTime());
        entity.setVisibility(state.getVisibility());
        entity.setTarget(!StringUtils.isBlank((CharSequence)state.getTarget()) ? NodeTarget.valueOf((String)state.getTarget()) : NodeTarget.SAME_TAB);
        entity.setUpdatedDate(System.currentTimeMillis());
    }

    private NodeData buildNodeData(NodeEntity node) {
        if (node == null) {
            return null;
        }
        String parentId = null;
        if (node.getParent() != null) {
            parentId = node.getParent().getId().toString();
        }
        ArrayList<String> children = new ArrayList<String>();
        if (node.getChildren() != null) {
            for (NodeEntity child : node.getChildren()) {
                children.add(child.getId().toString());
            }
        }
        NodeState.Builder builder = new NodeState.Builder();
        builder.endPublicationTime(node.getEndTime()).icon(node.getIcon()).label(node.getLabel()).startPublicationTime(node.getStartTime()).visibility(node.getVisibility()).target(node.getTarget() != null ? node.getTarget().name() : null).updatedDate(node.getUpdatedDate());
        PageEntity page = node.getPage();
        if (page != null && StringUtils.isNotBlank((CharSequence)page.getProfiles())) {
            Set activeProfiles = Tools.parseCommaList((String)page.getProfiles());
            if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) {
                page = null;
            }
        }
        if (page != null) {
            SiteKey siteKey = new SiteKey(page.getOwnerType(), page.getOwnerId());
            PageKey pageKey = new PageKey(siteKey, page.getName());
            builder.pageRef(pageKey);
        }
        NodeState state = builder.build();
        Long nodeId = node.getId();
        SiteKey navigationSiteKey = this.getSiteKey(nodeId);
        return new NodeData(parentId, node.getId().toString(), navigationSiteKey, node.getName(), state, children.toArray(new String[children.size()]), node.getTarget() != null ? node.getTarget().name() : null, node.getUpdatedDate());
    }

    private SiteKey getSiteKey(Long nodeId) {
        SiteKey siteKey;
        NodeEntity rootNode = this.getRootNode(nodeId);
        SiteKey siteKey2 = siteKey = rootNode == null || rootNode.getNavigationEntity() == null ? null : rootNode.getNavigationEntity().getOwnerType().key(rootNode.getNavigationEntity().getOwnerId());
        if (siteKey == null && rootNode != null) {
            NavigationEntity navigationEntity = this.navigationDAO.findByRootNode(rootNode.getId());
            return navigationEntity == null ? null : navigationEntity.getOwnerType().key(navigationEntity.getOwnerId());
        }
        return siteKey;
    }

    private void removeDescriptions(NodeEntity node) {
        if (node != null) {
            this.descriptionStorage.setDescription(node.getId().toString(), null);
            List<NodeEntity> children = node.getChildren();
            if (children != null) {
                children.forEach(this::removeDescriptions);
            }
        }
    }
}

