/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.elasticsearch.core.health_report.DiagnosisAffectedResources;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Diagnosis
implements JsonpSerializable {
    private final String id;
    private final String action;
    private final DiagnosisAffectedResources affectedResources;
    private final String cause;
    private final String helpUrl;
    public static final JsonpDeserializer<Diagnosis> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Diagnosis::setupDiagnosisDeserializer);

    private Diagnosis(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.action = ApiTypeHelper.requireNonNull(builder.action, this, "action");
        this.affectedResources = ApiTypeHelper.requireNonNull(builder.affectedResources, this, "affectedResources");
        this.cause = ApiTypeHelper.requireNonNull(builder.cause, this, "cause");
        this.helpUrl = ApiTypeHelper.requireNonNull(builder.helpUrl, this, "helpUrl");
    }

    public static Diagnosis of(Function<Builder, ObjectBuilder<Diagnosis>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final String action() {
        return this.action;
    }

    public final DiagnosisAffectedResources affectedResources() {
        return this.affectedResources;
    }

    public final String cause() {
        return this.cause;
    }

    public final String helpUrl() {
        return this.helpUrl;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("affected_resources");
        this.affectedResources.serialize(generator, mapper);
        generator.writeKey("cause");
        generator.write(this.cause);
        generator.writeKey("help_url");
        generator.write(this.helpUrl);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDiagnosisDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(Builder::affectedResources, DiagnosisAffectedResources._DESERIALIZER, "affected_resources");
        op.add(Builder::cause, JsonpDeserializer.stringDeserializer(), "cause");
        op.add(Builder::helpUrl, JsonpDeserializer.stringDeserializer(), "help_url");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Diagnosis> {
        private String id;
        private String action;
        private DiagnosisAffectedResources affectedResources;
        private String cause;
        private String helpUrl;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder action(String value) {
            this.action = value;
            return this;
        }

        public final Builder affectedResources(DiagnosisAffectedResources value) {
            this.affectedResources = value;
            return this;
        }

        public final Builder affectedResources(Function<DiagnosisAffectedResources.Builder, ObjectBuilder<DiagnosisAffectedResources>> fn) {
            return this.affectedResources(fn.apply(new DiagnosisAffectedResources.Builder()).build());
        }

        public final Builder cause(String value) {
            this.cause = value;
            return this;
        }

        public final Builder helpUrl(String value) {
            this.helpUrl = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Diagnosis build() {
            this._checkSingleUse();
            return new Diagnosis(this);
        }
    }
}

