/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.security.BulkUpdateApiKeysResponse;
import co.elastic.clients.elasticsearch.security.RoleDescriptor;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkUpdateApiKeysRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time expiration;
    private final List<String> ids;
    private final Map<String, JsonData> metadata;
    private final Map<String, RoleDescriptor> roleDescriptors;
    public static final JsonpDeserializer<BulkUpdateApiKeysRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkUpdateApiKeysRequest::setupBulkUpdateApiKeysRequestDeserializer);
    public static final Endpoint<BulkUpdateApiKeysRequest, BulkUpdateApiKeysResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<BulkUpdateApiKeysRequest, BulkUpdateApiKeysResponse>("es/security.bulk_update_api_keys", request -> "POST", request -> "/_security/api_key/_bulk_update", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, BulkUpdateApiKeysResponse._DESERIALIZER);

    private BulkUpdateApiKeysRequest(Builder builder) {
        this.expiration = builder.expiration;
        this.ids = ApiTypeHelper.unmodifiableRequired(builder.ids, (Object)this, "ids");
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.roleDescriptors = ApiTypeHelper.unmodifiable(builder.roleDescriptors);
    }

    public static BulkUpdateApiKeysRequest of(Function<Builder, ObjectBuilder<BulkUpdateApiKeysRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time expiration() {
        return this.expiration;
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final Map<String, RoleDescriptor> roleDescriptors() {
        return this.roleDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.expiration != null) {
            generator.writeKey("expiration");
            this.expiration.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String string : this.ids) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roleDescriptors)) {
            generator.writeKey("role_descriptors");
            generator.writeStartObject();
            for (Map.Entry entry : this.roleDescriptors.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RoleDescriptor)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupBulkUpdateApiKeysRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expiration, Time._DESERIALIZER, "expiration");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::roleDescriptors, JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER), "role_descriptors");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BulkUpdateApiKeysRequest> {
        @Nullable
        private Time expiration;
        private List<String> ids;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Map<String, RoleDescriptor> roleDescriptors;

        public final Builder expiration(@Nullable Time value) {
            this.expiration = value;
            return this;
        }

        public final Builder expiration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expiration(fn.apply(new Time.Builder()).build());
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder roleDescriptors(Map<String, RoleDescriptor> map) {
            this.roleDescriptors = Builder._mapPutAll(this.roleDescriptors, map);
            return this;
        }

        public final Builder roleDescriptors(String key, RoleDescriptor value) {
            this.roleDescriptors = Builder._mapPut(this.roleDescriptors, key, value);
            return this;
        }

        public final Builder roleDescriptors(String key, Function<RoleDescriptor.Builder, ObjectBuilder<RoleDescriptor>> fn) {
            return this.roleDescriptors(key, fn.apply(new RoleDescriptor.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkUpdateApiKeysRequest build() {
            this._checkSingleUse();
            return new BulkUpdateApiKeysRequest(this);
        }
    }
}

