/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class SqlStatementLoggerInitiator
implements StandardServiceInitiator<SqlStatementLogger> {
    private static final String OLD_LOG_SLOW_QUERY = "hibernate.session.events.log.LOG_QUERIES_SLOWER_THAN_MS";
    public static final SqlStatementLoggerInitiator INSTANCE = new SqlStatementLoggerInitiator();

    @Override
    public SqlStatementLogger initiateService(Map<String, Object> configValues, ServiceRegistryImplementor registry) {
        boolean showSQL = ConfigurationHelper.getBoolean("hibernate.show_sql", configValues);
        boolean formatSQL = ConfigurationHelper.getBoolean("hibernate.format_sql", configValues);
        boolean highlightSQL = ConfigurationHelper.getBoolean("hibernate.highlight_sql", configValues);
        long logSlowQuery = ConfigurationHelper.getLong("hibernate.log_slow_query", configValues, -2);
        if (logSlowQuery == -2L) {
            logSlowQuery = ConfigurationHelper.getLong(OLD_LOG_SLOW_QUERY, configValues, 0);
        }
        return new SqlStatementLogger(showSQL, formatSQL, highlightSQL, logSlowQuery);
    }

    @Override
    public Class<SqlStatementLogger> getServiceInitiated() {
        return SqlStatementLogger.class;
    }
}

