/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.reward.storage;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardReport;
import io.meeds.wallet.model.RewardStatus;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import io.meeds.wallet.model.WalletReward;
import io.meeds.wallet.model.WalletRewardPeriodSummary;
import io.meeds.wallet.model.WalletRewardStatus;
import io.meeds.wallet.reward.dao.RewardDAO;
import io.meeds.wallet.reward.dao.RewardPeriodDAO;
import io.meeds.wallet.reward.dao.RewardPeriodSummaryDAO;
import io.meeds.wallet.reward.entity.WalletRewardEntity;
import io.meeds.wallet.reward.entity.WalletRewardPeriodEntity;
import io.meeds.wallet.reward.entity.WalletRewardPeriodSummaryEntity;
import io.meeds.wallet.service.WalletAccountService;
import io.meeds.wallet.service.WalletTransactionService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class WalletRewardReportStorage {
    private static final Log LOG = ExoLogger.getLogger(WalletRewardReportStorage.class);
    @Autowired
    private RewardDAO rewardDAO;
    @Autowired
    private RewardPeriodDAO rewardPeriodDAO;
    @Autowired
    private RewardPeriodSummaryDAO rewardPeriodSummaryDAO;
    @Autowired
    private WalletAccountService walletAccountService;
    @Autowired
    private WalletTransactionService walletTransactionService;

    public Page<RewardPeriod> findRewardReportPeriods(Pageable pageable) {
        Page rewardPeriodEntities = this.rewardPeriodDAO.findAll(pageable);
        return rewardPeriodEntities.map(this::toDTO);
    }

    public Page<RewardPeriod> findRewardPeriodsBetween(long from, long to, Pageable pageable) {
        Page<WalletRewardPeriodEntity> rewardPeriodEntities = this.rewardPeriodDAO.findRewardPeriodsBetween(from, to, pageable);
        return rewardPeriodEntities.map(this::toDTO);
    }

    public RewardReport getRewardReportByPeriodId(long id, ZoneId zoneId) {
        return this.getRewardReport(this.rewardPeriodDAO.findById(id).orElse(null), zoneId);
    }

    public RewardReport getRewardReport(RewardPeriodType periodType, LocalDate date, ZoneId zoneId) {
        RewardPeriod period = periodType.getPeriodOfTime(date, zoneId);
        WalletRewardPeriodEntity rewardPeriodEntity = this.rewardPeriodDAO.findRewardPeriodByTypeAndTime(periodType, period.getPeriodMedianDateInSeconds());
        return this.getRewardReport(rewardPeriodEntity, zoneId);
    }

    public RewardPeriod getRewardPeriod(RewardPeriodType periodType, LocalDate date, ZoneId zoneId) {
        RewardPeriod period = periodType.getPeriodOfTime(date, zoneId);
        WalletRewardPeriodEntity rewardPeriodEntity = this.rewardPeriodDAO.findRewardPeriodByTypeAndTime(periodType, period.getPeriodMedianDateInSeconds());
        return this.toDTO(rewardPeriodEntity);
    }

    public RewardPeriod getRewardPeriodById(long rewardPeriodId) {
        WalletRewardPeriodEntity rewardPeriodEntity = this.rewardPeriodDAO.findById(rewardPeriodId).orElse(null);
        return this.toDTO(rewardPeriodEntity);
    }

    private RewardReport getRewardReport(WalletRewardPeriodEntity rewardPeriodEntity, ZoneId zoneId) {
        if (rewardPeriodEntity == null) {
            return null;
        }
        RewardReport rewardReport = new RewardReport();
        RewardPeriod periodOfTime = this.toDTO(rewardPeriodEntity);
        periodOfTime = periodOfTime.getRewardPeriodType().getPeriodOfTime(periodOfTime.getPeriodMedianDate(), zoneId);
        periodOfTime.setId(rewardPeriodEntity.getId().longValue());
        rewardReport.setPeriod(periodOfTime);
        List<WalletRewardEntity> rewardEntities = this.rewardDAO.findRewardsByPeriodId(rewardPeriodEntity.getId());
        if (rewardEntities != null) {
            ArrayList walletRewardEntities = new ArrayList();
            rewardEntities.forEach(reward -> {
                List<WalletRewardEntity> walletRewardList = rewardEntities.stream().filter(wr -> Objects.equals(wr.getIdentityId(), reward.getIdentityId())).toList();
                if (walletRewardList.size() == 1) {
                    walletRewardEntities.add(reward);
                } else {
                    WalletRewardEntity walletRewardEntity = walletRewardList.stream().filter(r -> r.getTransactionHash() != null).min((r2, r1) -> Double.compare(r1.getTokensSent(), r2.getTokensSent())).orElseGet(walletRewardList::getFirst);
                    if (walletRewardEntity.getId().longValue() == reward.getId().longValue()) {
                        walletRewardEntities.add(reward);
                    }
                }
            });
            Set rewards = walletRewardEntities.stream().map(rewardEntity -> this.toDTO((WalletRewardEntity)rewardEntity, zoneId)).collect(Collectors.toSet());
            rewardReport.setRewards(rewards);
        }
        return rewardReport;
    }

    public void saveRewardReport(RewardReport rewardReport) {
        if (rewardReport == null) {
            throw new IllegalArgumentException("reward report is null");
        }
        RewardPeriod period = rewardReport.getPeriod();
        WalletRewardPeriodEntity rewardPeriodEntity = this.rewardPeriodDAO.findRewardPeriodByTypeAndTime(period.getRewardPeriodType(), period.getPeriodMedianDateInSeconds());
        if (rewardPeriodEntity == null) {
            rewardPeriodEntity = new WalletRewardPeriodEntity();
        } else if (rewardPeriodEntity.getStatus() == RewardStatus.SUCCESS) {
            LOG.warn("Reward report  from {} to {} shouldn't be modified because it has been already marked as completed.", new Object[]{period.getStartDateFormatted("en"), period.getEndDateFormatted("en")});
        }
        rewardPeriodEntity.setPeriodType(period.getRewardPeriodType());
        rewardPeriodEntity.setStartTime(period.getStartDateInSeconds());
        rewardPeriodEntity.setEndTime(period.getEndDateInSeconds());
        rewardPeriodEntity.setTimeZone(period.getTimeZone());
        if (rewardReport.isCompletelyProcessed()) {
            rewardPeriodEntity.setStatus(RewardStatus.SUCCESS);
        } else if (rewardReport.getPendingTransactionCount() > 0L) {
            rewardPeriodEntity.setStatus(RewardStatus.PENDING);
        } else if (rewardReport.getFailedTransactionCount() > 0L) {
            rewardPeriodEntity.setStatus(RewardStatus.ERROR);
        } else if (rewardReport.getTransactionsCount() > 0L) {
            rewardPeriodEntity.setStatus(RewardStatus.PENDING);
        } else {
            rewardPeriodEntity.setStatus(RewardStatus.ESTIMATION);
        }
        rewardPeriodEntity = (WalletRewardPeriodEntity)this.rewardPeriodDAO.save(rewardPeriodEntity);
        Set rewards = rewardReport.getRewards();
        for (WalletReward walletReward : rewards) {
            if (walletReward.getWallet() == null || StringUtils.isBlank((CharSequence)walletReward.getWallet().getAddress())) continue;
            long identityId = walletReward.getIdentityId();
            List<WalletRewardEntity> rewardEntities = this.rewardDAO.findRewardByIdentityIdAndPeriodId(identityId, rewardPeriodEntity.getId());
            WalletRewardEntity rewardEntity = CollectionUtils.isEmpty(rewardEntities) ? null : WalletRewardReportStorage.getFirstItem(rewardEntities);
            if (rewardEntity == null) {
                rewardEntity = new WalletRewardEntity();
            }
            rewardEntity.setTokensSent(walletReward.getTokensSent());
            rewardEntity.setTokensToSend(walletReward.getAmount());
            rewardEntity.setPoints(walletReward.getPoints());
            rewardEntity.setEnabled(walletReward.isEnabled());
            rewardEntity.setIdentityId(identityId);
            rewardEntity.setPeriod(rewardPeriodEntity);
            TransactionDetail rewardTransaction = walletReward.getTransaction();
            rewardEntity.setTransactionHash(rewardTransaction == null ? null : rewardTransaction.getHash());
            this.rewardDAO.save(rewardEntity);
        }
    }

    public List<RewardPeriod> findRewardPeriodsByStatus(RewardStatus rewardStatus) {
        List<WalletRewardPeriodEntity> rewardPeriodEntities = this.rewardPeriodDAO.findWalletRewardPeriodEntitiesByStatus(rewardStatus);
        return rewardPeriodEntities.stream().map(this::toDTO).toList();
    }

    public List<WalletReward> listRewards(long identityId, ZoneId zoneId, int limit) {
        PageRequest pageable = PageRequest.of((int)0, (int)limit);
        List<WalletRewardEntity> rewardEntities = this.rewardDAO.findWalletRewardEntitiesByIdentityId(identityId, (Pageable)pageable);
        List<WalletReward> walletRewards = rewardEntities.stream().map(rewardEntity -> this.toDTO((WalletRewardEntity)rewardEntity, zoneId)).toList();
        if (!walletRewards.isEmpty()) {
            WalletReward walletReward = walletRewards.getFirst();
            Wallet wallet = walletReward.getWallet();
            this.walletAccountService.retrieveWalletBlockchainState(wallet);
            walletRewards.forEach(wr -> wr.setWallet(wallet));
        }
        return walletRewards;
    }

    public double countRewards(long identityId) {
        double countRewardsByUser = this.rewardDAO.countWalletRewardEntitiesByIdentityId(identityId);
        return Double.isNaN(countRewardsByUser) ? 0.0 : countRewardsByUser;
    }

    public void replaceRewardTransactions(String oldHash, String newHash) {
        this.rewardDAO.replaceRewardTransactions(oldHash, newHash);
    }

    public Page<WalletReward> findWalletRewardsByPeriodIdAndIdentityIds(long periodId, List<Long> identityIds, ZoneId zoneId, WalletRewardStatus walletRewardStatus, Pageable pageable) {
        Page<WalletRewardEntity> walletRewardEntities = this.rewardDAO.findWalletRewardsByPeriodIdAndIdentityIds(periodId, identityIds, walletRewardStatus.name(), pageable);
        return walletRewardEntities.map(walletRewardEntity -> this.toDTO((WalletRewardEntity)walletRewardEntity, zoneId));
    }

    public Page<WalletReward> findWalletRewardsByPeriodId(long periodId, ZoneId zoneId, WalletRewardStatus walletRewardStatus, Pageable pageable) {
        Page<WalletRewardEntity> walletRewardEntities = this.rewardDAO.findWalletRewardsByPeriodId(periodId, walletRewardStatus.name(), pageable);
        return walletRewardEntities.map(walletRewardEntity -> this.toDTO((WalletRewardEntity)walletRewardEntity, zoneId));
    }

    public double countWalletRewardsPointsByPeriodIdAndStatus(long periodId, boolean isValid) {
        Double countWalletRewardsPoints = this.rewardDAO.countWalletRewardsPointsByPeriodIdAndStatus(periodId, isValid);
        return countWalletRewardsPoints != null ? countWalletRewardsPoints : 0.0;
    }

    @Transactional
    public void deleteRewardById(long rewardId) {
        this.rewardDAO.deleteById(rewardId);
    }

    @Transactional
    public void deleteRewardsByPeriodId(long periodId) {
        this.rewardDAO.deleteRewardsByPeriodId(periodId);
    }

    public WalletRewardPeriodSummary findWalletRewardPeriodSummaryByRewardPeriodId(Long rewardPeriodId) {
        WalletRewardPeriodSummaryEntity walletRewardPeriodSummaryEntity = this.rewardPeriodSummaryDAO.findTopByRewardPeriod_IdOrderByIdDesc(rewardPeriodId).orElse(null);
        if (walletRewardPeriodSummaryEntity == null) {
            return null;
        }
        return this.toDTO(walletRewardPeriodSummaryEntity);
    }

    public WalletRewardPeriodSummary createOrUpdateSummary(WalletRewardPeriodSummary walletRewardPeriodSummary) {
        WalletRewardPeriodSummaryEntity summary = this.createOrUpdateSummaryForRewardPeriod(walletRewardPeriodSummary);
        if (summary == null) {
            return null;
        }
        return this.toDTO(summary);
    }

    private WalletRewardPeriodSummaryEntity createOrUpdateSummaryForRewardPeriod(WalletRewardPeriodSummary walletRewardPeriodSummary) {
        return this.rewardPeriodSummaryDAO.findTopByRewardPeriod_IdOrderByIdDesc(walletRewardPeriodSummary.getPeriod().getId()).map(existingSummary -> this.updateSummary((WalletRewardPeriodSummaryEntity)existingSummary, walletRewardPeriodSummary)).orElseGet(() -> this.createSummary(walletRewardPeriodSummary));
    }

    private WalletRewardPeriodSummaryEntity updateSummary(WalletRewardPeriodSummaryEntity existing, WalletRewardPeriodSummary newSummary) {
        existing.setPoints(newSummary.getPoints());
        existing.setAchievementsCount(newSummary.getAchievementsCount());
        existing.setParticipantsCount(newSummary.getParticipantsCount());
        existing.setRecipientsCount(newSummary.getRecipientsCount());
        existing.setTokensSent(newSummary.getTokensSent());
        existing.setTokensToSend(newSummary.getTokensToSend());
        existing.setCompletelyProcessed(newSummary.isCompletelyProcessed());
        existing.setSentDate(newSummary.getSentDate());
        return (WalletRewardPeriodSummaryEntity)this.rewardPeriodSummaryDAO.save(existing);
    }

    private WalletRewardPeriodSummaryEntity createSummary(WalletRewardPeriodSummary walletRewardPeriodSummary) {
        WalletRewardPeriodSummaryEntity summary = new WalletRewardPeriodSummaryEntity();
        long rewardPeriodId = walletRewardPeriodSummary.getPeriod().getId();
        this.rewardPeriodDAO.findById(rewardPeriodId).ifPresent(summary::setRewardPeriod);
        if (summary.getRewardPeriod() == null) {
            return null;
        }
        summary.setPoints(walletRewardPeriodSummary.getPoints());
        summary.setAchievementsCount(walletRewardPeriodSummary.getAchievementsCount());
        summary.setParticipantsCount(walletRewardPeriodSummary.getParticipantsCount());
        summary.setRecipientsCount(walletRewardPeriodSummary.getRecipientsCount());
        summary.setTokensSent(walletRewardPeriodSummary.getTokensSent());
        summary.setTokensToSend(walletRewardPeriodSummary.getTokensToSend());
        summary.setCompletelyProcessed(walletRewardPeriodSummary.isCompletelyProcessed());
        summary.setSentDate(walletRewardPeriodSummary.getSentDate());
        return (WalletRewardPeriodSummaryEntity)this.rewardPeriodSummaryDAO.save(summary);
    }

    private RewardPeriod toDTO(WalletRewardPeriodEntity period) {
        if (period == null) {
            return null;
        }
        RewardPeriod rewardPeriod = new RewardPeriod(period.getPeriodType());
        rewardPeriod.setId(period.getId().longValue());
        rewardPeriod.setStartDateInSeconds(period.getStartTime().longValue());
        rewardPeriod.setEndDateInSeconds(period.getEndTime().longValue());
        if (StringUtils.isNotBlank((CharSequence)period.getTimeZone())) {
            rewardPeriod.setTimeZone(period.getTimeZone());
        }
        rewardPeriod.setStatus(period.getStatus());
        return rewardPeriod;
    }

    private WalletReward toDTO(WalletRewardEntity rewardEntity, ZoneId zoneId) {
        WalletReward walletReward = new WalletReward();
        walletReward.setId(rewardEntity.getId().longValue());
        walletReward.setAmount(rewardEntity.getTokensToSend());
        walletReward.setPoints(rewardEntity.getPoints() == null ? 0.0 : rewardEntity.getPoints());
        this.retrieveWallet(rewardEntity, walletReward);
        this.retrieveTransaction(rewardEntity, walletReward);
        WalletRewardPeriodEntity periodEntity = rewardEntity.getPeriod();
        if (periodEntity != null && periodEntity.getPeriodType() != null) {
            RewardPeriodType rewardPeriodType = periodEntity.getPeriodType();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(periodEntity.getStartTime()), zoneId);
            walletReward.setPeriod(rewardPeriodType.getPeriodOfTime(zonedDateTime));
            Integer rank = this.rewardDAO.findRankById(rewardEntity.getId(), periodEntity.getId());
            walletReward.setRank(rank != null ? rank : 0);
        }
        return walletReward;
    }

    private WalletRewardPeriodSummary toDTO(WalletRewardPeriodSummaryEntity rewardPeriodSummaryEntity) {
        WalletRewardPeriodSummary walletRewardPeriodSummary = new WalletRewardPeriodSummary();
        walletRewardPeriodSummary.setPeriod(this.toDTO(rewardPeriodSummaryEntity.getRewardPeriod()));
        walletRewardPeriodSummary.setPoints(rewardPeriodSummaryEntity.getPoints().doubleValue());
        walletRewardPeriodSummary.setAchievementsCount(rewardPeriodSummaryEntity.getAchievementsCount().longValue());
        walletRewardPeriodSummary.setParticipantsCount(rewardPeriodSummaryEntity.getParticipantsCount().longValue());
        walletRewardPeriodSummary.setRecipientsCount(rewardPeriodSummaryEntity.getRecipientsCount().longValue());
        walletRewardPeriodSummary.setTokensSent(rewardPeriodSummaryEntity.getTokensSent());
        walletRewardPeriodSummary.setTokensToSend(rewardPeriodSummaryEntity.getTokensToSend());
        walletRewardPeriodSummary.setCompletelyProcessed(rewardPeriodSummaryEntity.getCompletelyProcessed().booleanValue());
        walletRewardPeriodSummary.setSentDate(rewardPeriodSummaryEntity.getSentDate().longValue());
        return walletRewardPeriodSummary;
    }

    private void retrieveTransaction(WalletRewardEntity rewardEntity, WalletReward walletReward) {
        String transactionHash = rewardEntity.getTransactionHash();
        if (StringUtils.isNotBlank((CharSequence)transactionHash)) {
            TransactionDetail transactionDetail = this.walletTransactionService.getTransactionByHash(transactionHash);
            walletReward.setTransaction(transactionDetail);
        }
    }

    private void retrieveWallet(WalletRewardEntity rewardEntity, WalletReward walletReward) {
        Wallet wallet = this.walletAccountService.getWalletByIdentityId(rewardEntity.getIdentityId().longValue());
        walletReward.setWallet(wallet);
    }

    private static WalletRewardEntity getFirstItem(List<WalletRewardEntity> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        return resultList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getTransactionHash())).min((r2, r1) -> Double.compare(r1.getTokensSent(), r2.getTokensSent())).orElse(resultList.getFirst());
    }
}

