/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectOption;

public class SelectOptionGroup
extends SelectItem {
    private List<SelectOption> options_;

    public SelectOptionGroup(String label) {
        this(label, new ArrayList<SelectOption>(3));
    }

    public SelectOptionGroup(String label, List<SelectOption> list) {
        super(label);
        if (list == null) {
            list = new ArrayList<SelectOption>(3);
        }
        this.options_ = list;
    }

    public List<SelectOption> getOptions() {
        return this.options_;
    }

    public void setOptions(List<SelectOption> options) {
        this.options_ = options;
    }

    public void addOption(SelectOption option) {
        if (this.options_ == null) {
            this.options_ = new ArrayList<SelectOption>(3);
        }
        this.options_.add(option);
    }

    public void setSelectedValue(String[] values) {
        block0: for (SelectOption option : this.options_) {
            option.setSelected(false);
            for (String value : values) {
                if (!value.equals(option.getValue())) continue;
                option.setSelected(true);
                continue block0;
            }
        }
    }

    public void setValue(String value) {
        for (SelectOption option : this.options_) {
            if (option.getValue().equals(value)) {
                option.setSelected(true);
                continue;
            }
            option.setSelected(false);
        }
    }

    public Collection<String> getSelectedValues() {
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (int i = 0; i < this.options_.size(); ++i) {
            SelectOption item = this.options_.get(i);
            if (!item.isSelected()) continue;
            selectedValues.add(item.getValue());
        }
        return selectedValues;
    }

    public void reset() {
        if (this.options_ == null || this.options_.size() < 1) {
            return;
        }
        for (SelectOption option : this.options_) {
            option.setSelected(false);
        }
        this.options_.get(0).setSelected(true);
    }
}

