/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ccr.ResumeFollowResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ResumeFollowRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Long maxOutstandingReadRequests;
    @Nullable
    private final Long maxOutstandingWriteRequests;
    @Nullable
    private final Long maxReadRequestOperationCount;
    @Nullable
    private final String maxReadRequestSize;
    @Nullable
    private final Time maxRetryDelay;
    @Nullable
    private final Long maxWriteBufferCount;
    @Nullable
    private final String maxWriteBufferSize;
    @Nullable
    private final Long maxWriteRequestOperationCount;
    @Nullable
    private final String maxWriteRequestSize;
    @Nullable
    private final Time readPollTimeout;
    public static final JsonpDeserializer<ResumeFollowRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResumeFollowRequest::setupResumeFollowRequestDeserializer);
    public static final Endpoint<ResumeFollowRequest, ResumeFollowResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ResumeFollowRequest, ResumeFollowResponse>("es/ccr.resume_follow", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ccr");
            buf.append("/resume_follow");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("index", request.index);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ResumeFollowResponse._DESERIALIZER);

    private ResumeFollowRequest(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.masterTimeout = builder.masterTimeout;
        this.maxOutstandingReadRequests = builder.maxOutstandingReadRequests;
        this.maxOutstandingWriteRequests = builder.maxOutstandingWriteRequests;
        this.maxReadRequestOperationCount = builder.maxReadRequestOperationCount;
        this.maxReadRequestSize = builder.maxReadRequestSize;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxWriteBufferCount = builder.maxWriteBufferCount;
        this.maxWriteBufferSize = builder.maxWriteBufferSize;
        this.maxWriteRequestOperationCount = builder.maxWriteRequestOperationCount;
        this.maxWriteRequestSize = builder.maxWriteRequestSize;
        this.readPollTimeout = builder.readPollTimeout;
    }

    public static ResumeFollowRequest of(Function<Builder, ObjectBuilder<ResumeFollowRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Long maxOutstandingReadRequests() {
        return this.maxOutstandingReadRequests;
    }

    @Nullable
    public final Long maxOutstandingWriteRequests() {
        return this.maxOutstandingWriteRequests;
    }

    @Nullable
    public final Long maxReadRequestOperationCount() {
        return this.maxReadRequestOperationCount;
    }

    @Nullable
    public final String maxReadRequestSize() {
        return this.maxReadRequestSize;
    }

    @Nullable
    public final Time maxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Nullable
    public final Long maxWriteBufferCount() {
        return this.maxWriteBufferCount;
    }

    @Nullable
    public final String maxWriteBufferSize() {
        return this.maxWriteBufferSize;
    }

    @Nullable
    public final Long maxWriteRequestOperationCount() {
        return this.maxWriteRequestOperationCount;
    }

    @Nullable
    public final String maxWriteRequestSize() {
        return this.maxWriteRequestSize;
    }

    @Nullable
    public final Time readPollTimeout() {
        return this.readPollTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxOutstandingReadRequests != null) {
            generator.writeKey("max_outstanding_read_requests");
            generator.write(this.maxOutstandingReadRequests.longValue());
        }
        if (this.maxOutstandingWriteRequests != null) {
            generator.writeKey("max_outstanding_write_requests");
            generator.write(this.maxOutstandingWriteRequests.longValue());
        }
        if (this.maxReadRequestOperationCount != null) {
            generator.writeKey("max_read_request_operation_count");
            generator.write(this.maxReadRequestOperationCount.longValue());
        }
        if (this.maxReadRequestSize != null) {
            generator.writeKey("max_read_request_size");
            generator.write(this.maxReadRequestSize);
        }
        if (this.maxRetryDelay != null) {
            generator.writeKey("max_retry_delay");
            this.maxRetryDelay.serialize(generator, mapper);
        }
        if (this.maxWriteBufferCount != null) {
            generator.writeKey("max_write_buffer_count");
            generator.write(this.maxWriteBufferCount.longValue());
        }
        if (this.maxWriteBufferSize != null) {
            generator.writeKey("max_write_buffer_size");
            generator.write(this.maxWriteBufferSize);
        }
        if (this.maxWriteRequestOperationCount != null) {
            generator.writeKey("max_write_request_operation_count");
            generator.write(this.maxWriteRequestOperationCount.longValue());
        }
        if (this.maxWriteRequestSize != null) {
            generator.writeKey("max_write_request_size");
            generator.write(this.maxWriteRequestSize);
        }
        if (this.readPollTimeout != null) {
            generator.writeKey("read_poll_timeout");
            this.readPollTimeout.serialize(generator, mapper);
        }
    }

    protected static void setupResumeFollowRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxOutstandingReadRequests, JsonpDeserializer.longDeserializer(), "max_outstanding_read_requests");
        op.add(Builder::maxOutstandingWriteRequests, JsonpDeserializer.longDeserializer(), "max_outstanding_write_requests");
        op.add(Builder::maxReadRequestOperationCount, JsonpDeserializer.longDeserializer(), "max_read_request_operation_count");
        op.add(Builder::maxReadRequestSize, JsonpDeserializer.stringDeserializer(), "max_read_request_size");
        op.add(Builder::maxRetryDelay, Time._DESERIALIZER, "max_retry_delay");
        op.add(Builder::maxWriteBufferCount, JsonpDeserializer.longDeserializer(), "max_write_buffer_count");
        op.add(Builder::maxWriteBufferSize, JsonpDeserializer.stringDeserializer(), "max_write_buffer_size");
        op.add(Builder::maxWriteRequestOperationCount, JsonpDeserializer.longDeserializer(), "max_write_request_operation_count");
        op.add(Builder::maxWriteRequestSize, JsonpDeserializer.stringDeserializer(), "max_write_request_size");
        op.add(Builder::readPollTimeout, Time._DESERIALIZER, "read_poll_timeout");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ResumeFollowRequest> {
        private String index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Long maxOutstandingReadRequests;
        @Nullable
        private Long maxOutstandingWriteRequests;
        @Nullable
        private Long maxReadRequestOperationCount;
        @Nullable
        private String maxReadRequestSize;
        @Nullable
        private Time maxRetryDelay;
        @Nullable
        private Long maxWriteBufferCount;
        @Nullable
        private String maxWriteBufferSize;
        @Nullable
        private Long maxWriteRequestOperationCount;
        @Nullable
        private String maxWriteRequestSize;
        @Nullable
        private Time readPollTimeout;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxOutstandingReadRequests(@Nullable Long value) {
            this.maxOutstandingReadRequests = value;
            return this;
        }

        public final Builder maxOutstandingWriteRequests(@Nullable Long value) {
            this.maxOutstandingWriteRequests = value;
            return this;
        }

        public final Builder maxReadRequestOperationCount(@Nullable Long value) {
            this.maxReadRequestOperationCount = value;
            return this;
        }

        public final Builder maxReadRequestSize(@Nullable String value) {
            this.maxReadRequestSize = value;
            return this;
        }

        public final Builder maxRetryDelay(@Nullable Time value) {
            this.maxRetryDelay = value;
            return this;
        }

        public final Builder maxRetryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxRetryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxWriteBufferCount(@Nullable Long value) {
            this.maxWriteBufferCount = value;
            return this;
        }

        public final Builder maxWriteBufferSize(@Nullable String value) {
            this.maxWriteBufferSize = value;
            return this;
        }

        public final Builder maxWriteRequestOperationCount(@Nullable Long value) {
            this.maxWriteRequestOperationCount = value;
            return this;
        }

        public final Builder maxWriteRequestSize(@Nullable String value) {
            this.maxWriteRequestSize = value;
            return this;
        }

        public final Builder readPollTimeout(@Nullable Time value) {
            this.readPollTimeout = value;
            return this;
        }

        public final Builder readPollTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.readPollTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResumeFollowRequest build() {
            this._checkSingleUse();
            return new ResumeFollowRequest(this);
        }
    }
}

