/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.service;

import java.util.Collection;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.perkstore.model.WebSocketMessage;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class PerkStoreWebSocketService {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreWebSocketService.class);
    private ContinuationService continuationService;
    private EXoContinuationBayeux continuationBayeux;
    private String cometdContextName;

    public void sendMessage(String eventId, Collection<String> recipientUsers, boolean sendToAll, Object ... objects) {
        this.getContinuationService();
        WebSocketMessage messageObject = new WebSocketMessage(eventId, objects);
        String message = Utils.transformToString(messageObject);
        if (sendToAll) {
            this.continuationService.sendBroadcastMessage("/eXo/Application/Addons/PerkStore", (Object)message);
        } else {
            for (String recipientUser : recipientUsers) {
                if (!this.continuationService.isPresent(recipientUser)) continue;
                this.continuationService.sendMessage(recipientUser, "/eXo/Application/Addons/PerkStore", (Object)message);
            }
        }
    }

    protected String getCometdContextName() {
        if (this.cometdContextName == null) {
            this.getContinuationBayeux();
            this.cometdContextName = this.continuationBayeux == null ? "cometd" : this.continuationBayeux.getCometdContextName();
        }
        return this.cometdContextName;
    }

    protected String getUserToken(String username) {
        try {
            return this.getContinuationService().getUserToken(username);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not retrieve continuation token for user " + username), (Throwable)e);
            return "";
        }
    }

    private EXoContinuationBayeux getContinuationBayeux() {
        if (this.continuationBayeux == null) {
            this.continuationBayeux = (EXoContinuationBayeux)CommonsUtils.getService(EXoContinuationBayeux.class);
        }
        return this.continuationBayeux;
    }

    private ContinuationService getContinuationService() {
        if (this.continuationService == null) {
            this.continuationService = (ContinuationService)CommonsUtils.getService(ContinuationService.class);
        }
        return this.continuationService;
    }
}

