/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.manager.RelationshipManagerImpl;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsRelationshipListener
extends RelationshipListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(AnalyticsRelationshipListener.class);
    @Autowired
    private RelationshipManager relationshipManager;

    @PostConstruct
    public void init() {
        ((RelationshipManagerImpl)this.relationshipManager).addListenerPlugin((RelationshipListenerPlugin)this);
    }

    public void requested(RelationshipEvent event) {
        try {
            Relationship relationship = (Relationship)event.getPayload();
            StatisticData statisticData = this.buildStatisticData("requested", relationship.getSender().getId(), relationship.getReceiver().getId());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void denied(RelationshipEvent event) {
        try {
            Relationship relationship = (Relationship)event.getPayload();
            StatisticData statisticData = this.buildStatisticData("denied", relationship.getSender().getId(), relationship.getReceiver().getId());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void confirmed(RelationshipEvent event) {
        try {
            Relationship relationship = (Relationship)event.getPayload();
            StatisticData statisticData = this.buildStatisticData("confirmed", relationship.getSender().getId(), relationship.getReceiver().getId());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void ignored(RelationshipEvent event) {
        try {
            Relationship relationship = (Relationship)event.getPayload();
            StatisticData statisticData = this.buildStatisticData("ignored", relationship.getSender().getId(), relationship.getReceiver().getId());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void removed(RelationshipEvent event) {
        try {
            Relationship relationship = (Relationship)event.getPayload();
            StatisticData statisticData = this.buildStatisticData("removed", relationship.getSender().getId(), relationship.getReceiver().getId());
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    private StatisticData buildStatisticData(String operation, String from, String to) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("relationship");
        statisticData.setOperation(operation);
        statisticData.setUserId(AnalyticsUtils.getCurrentUserIdentityId());
        statisticData.addParameter("from", (Object)from);
        statisticData.addParameter("to", (Object)to);
        return statisticData;
    }

    private void handleErrorProcessingOperation(RelationshipEvent event, Exception exception) {
        LOG.warn("Error adding Statistic data for relationship {}/{} with event {}", new Object[]{((Relationship)event.getPayload()).getSender(), ((Relationship)event.getPayload()).getReceiver(), event.getType(), exception});
    }
}

