/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.exoplatform.commons.utils.PortalPrinter;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.gatein.portal.controller.resource.ResourceScope;

public class UIPortalApplicationLifecycle
extends Lifecycle<UIPortalApplication> {
    @Override
    public void processDecode(UIPortalApplication uicomponent, WebuiRequestContext context) throws Exception {
        String componentId = context.getRequestParameter(context.getUIComponentIdParameterName());
        if (componentId == null) {
            return;
        }
        Object uiTarget = uicomponent.findComponentById(componentId);
        if (uiTarget == null) {
            context.addUIComponentToUpdateByAjax((UIComponent)uicomponent.getChildById("UIWorkingWorkspace"));
            context.addUIComponentToUpdateByAjax(uicomponent.getChild(UIMaskWorkspace.class));
            PortalRequestContext.getCurrentInstance().ignoreAJAXUpdateOnPortlets(true);
            return;
        }
        if (uiTarget == uicomponent) {
            super.processDecode(uicomponent, context);
        } else {
            ((UIComponent)uiTarget).processDecode(context);
        }
    }

    @Override
    public void processAction(UIPortalApplication uicomponent, WebuiRequestContext context) throws Exception {
        String componentId = context.getRequestParameter(context.getUIComponentIdParameterName());
        if (componentId == null) {
            return;
        }
        Object uiTarget = uicomponent.findComponentById(componentId);
        if (uiTarget == null) {
            return;
        }
        if (uiTarget == uicomponent) {
            super.processAction(uicomponent, context);
        }
        ((UIComponent)uiTarget).processAction(context);
    }

    @Override
    public void processRender(UIPortalApplication uicomponent, WebuiRequestContext context) throws Exception {
        block5: {
            PortalRequestContext portalRequestContext = PortalRequestContext.getCurrentInstance();
            ServletOutputStream responseOutputStream = portalRequestContext.getResponse().getOutputStream();
            PortalPrinter parentWriter = new PortalPrinter((OutputStream)responseOutputStream, true, 5000);
            PortalPrinter childWriter = null;
            if (portalRequestContext.isFullRendering()) {
                JavascriptManager jsManager = portalRequestContext.getJavascriptManager();
                String portalOwner = portalRequestContext.getPortalOwner();
                jsManager.loadScriptResource(ResourceScope.PORTAL, portalOwner);
                jsManager.loadScriptResource(ResourceScope.SHARED, "merged");
                jsManager.loadScriptResource(ResourceScope.SHARED, "bootstrap");
                childWriter = new PortalPrinter((OutputStream)responseOutputStream, true, 25000, true);
                context.setWriter((Writer)childWriter);
                this.processRender(uicomponent, context, "system:/groovy/portal/webui/workspace/UIPortalApplicationChildren.gtmpl");
                context.setWriter((Writer)parentWriter);
                this.processRender(uicomponent, context, "system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl");
                portalRequestContext.setWriter((Writer)parentWriter);
            } else {
                portalRequestContext.setWriter((Writer)parentWriter);
                this.processRender(uicomponent, portalRequestContext, "system:/groovy/portal/webui/workspace/UIApplication.gtmpl");
            }
            try {
                portalRequestContext.commitResponse();
                parentWriter.flushOutputStream();
                if (childWriter != null) {
                    childWriter.flushOutputStream();
                }
            }
            catch (IOException e) {
                if (this.containsException(e, "ClientAbortException")) break block5;
                throw e;
            }
        }
    }

    public void processRender(UIPortalApplication uicomponent, WebuiRequestContext context, String template) throws Exception {
        if (template == null) {
            throw new IllegalStateException("uicomponent " + String.valueOf(uicomponent) + " with class " + uicomponent.getClass().getName() + " has no template for rendering");
        }
        ResourceResolver resolver = uicomponent.getTemplateResourceResolver(context, template);
        WebuiBindingContext bcontext = new WebuiBindingContext(resolver, context.getWriter(), uicomponent, context);
        bcontext.put("uicomponent", uicomponent);
        this.renderTemplate(template, bcontext);
    }

    private boolean containsException(Throwable e, String pattern) {
        return e != null && (e.getClass().toString().contains(pattern) || this.containsException(e.getCause(), pattern));
    }
}

