/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.exoplatform.social.common.Invocation;
import org.exoplatform.social.common.LockInterceptor;
import org.exoplatform.web.filter.Filter;
import org.gatein.pc.api.invocation.InvocationException;

public class RequestQueueingFilter
implements Filter {
    private SessionLockInterceptor interceptor = new SessionLockInterceptor(this);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.interceptor.invoke(new ServletFilterInvocation(this, chain, request, response));
        }
        catch (Exception e) {
            throw new ServletException(e.getCause());
        }
    }

    public class SessionLockInterceptor
    extends LockInterceptor<ServletFilterInvocation> {
        public SessionLockInterceptor(RequestQueueingFilter this$0) {
        }

        @Override
        protected Object getLockId(ServletFilterInvocation invocation) throws InvocationException {
            HttpServletRequest req = invocation.getRequest();
            return req.getRequestedSessionId();
        }
    }

    public class ServletFilterInvocation
    implements Invocation {
        private FilterChain filterChain;
        private ServletRequest request;
        private ServletResponse response;

        public ServletFilterInvocation(RequestQueueingFilter this$0, FilterChain filterChain, ServletRequest request, ServletResponse response) {
            this.filterChain = filterChain;
            this.request = request;
            this.response = response;
        }

        @Override
        public Object invokeNext() throws InvocationException {
            try {
                this.filterChain.doFilter(this.request, this.response);
            }
            catch (Exception e) {
                throw new InvocationException(e.getCause());
            }
            return null;
        }

        public HttpServletRequest getRequest() {
            return (HttpServletRequest)this.request;
        }
    }
}

