/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;

public record ClientHttpRequestFactorySettings(Redirects redirects, Duration connectTimeout, Duration readTimeout, SslBundle sslBundle) {
    private static final ClientHttpRequestFactorySettings defaults = new ClientHttpRequestFactorySettings(null, null, null, null);

    public ClientHttpRequestFactorySettings(Redirects redirects, Duration connectTimeout, Duration readTimeout, SslBundle sslBundle) {
        this.redirects = redirects = redirects != null ? redirects : Redirects.FOLLOW_WHEN_POSSIBLE;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.sslBundle = sslBundle;
    }

    public ClientHttpRequestFactorySettings withConnectTimeout(Duration connectTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, connectTimeout, this.readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withReadTimeout(Duration readTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, this.connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withTimeouts(Duration connectTimeout, Duration readTimeout) {
        return new ClientHttpRequestFactorySettings(this.redirects, connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpRequestFactorySettings withSslBundle(SslBundle sslBundle) {
        return new ClientHttpRequestFactorySettings(this.redirects, this.connectTimeout, this.readTimeout, sslBundle);
    }

    public ClientHttpRequestFactorySettings withRedirects(Redirects redirects) {
        return new ClientHttpRequestFactorySettings(redirects, this.connectTimeout, this.readTimeout, this.sslBundle);
    }

    public static ClientHttpRequestFactorySettings ofSslBundle(SslBundle sslBundle) {
        return ClientHttpRequestFactorySettings.defaults().withSslBundle(sslBundle);
    }

    public static ClientHttpRequestFactorySettings defaults() {
        return defaults;
    }

    public static enum Redirects {
        FOLLOW_WHEN_POSSIBLE(HttpRedirects.FOLLOW_WHEN_POSSIBLE),
        FOLLOW(HttpRedirects.FOLLOW),
        DONT_FOLLOW(HttpRedirects.DONT_FOLLOW);

        private final HttpRedirects httpClientRedirects;

        private Redirects(HttpRedirects httpClientRedirects) {
            this.httpClientRedirects = httpClientRedirects;
        }

        HttpRedirects httpClientRedirects() {
            return this.httpClientRedirects;
        }

        public static Redirects of(HttpRedirects httpRedirects) {
            Redirects redirects;
            if (httpRedirects != null) {
                switch (httpRedirects) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case FOLLOW_WHEN_POSSIBLE: {
                        redirects = FOLLOW_WHEN_POSSIBLE;
                        break;
                    }
                    case FOLLOW: {
                        redirects = FOLLOW;
                        break;
                    }
                    case DONT_FOLLOW: {
                        redirects = DONT_FOLLOW;
                        break;
                    }
                }
            } else {
                redirects = null;
            }
            return redirects;
        }
    }
}

