/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.internal;

import java.util.Arrays;
import java.util.Map;

public class ObjectToStringBuilder {
    private final StringBuilder sb;
    private String sep;

    private ObjectToStringBuilder(Class<?> type) {
        this.sb = new StringBuilder().append(type.getSimpleName()).append("[");
        this.sep = "";
    }

    private ObjectToStringBuilder() {
        this.sb = new StringBuilder("[");
        this.sep = "";
    }

    public static ObjectToStringBuilder toStringBuilder(Class<?> type) {
        return new ObjectToStringBuilder(type);
    }

    public static ObjectToStringBuilder toStringBuilder() {
        return new ObjectToStringBuilder();
    }

    public ObjectToStringBuilder add(String name, Object object) {
        this.sb.append(this.sep).append(name).append("=").append(ObjectToStringBuilder.toString(object));
        this.sep = ", ";
        return this;
    }

    public ObjectToStringBuilder add(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.add(ObjectToStringBuilder.toString(entry.getKey()), entry.getValue());
        }
        this.sep = ", ";
        return this;
    }

    private static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }

    public String toString() {
        return this.sb.append("]").toString();
    }
}

