/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.plugin;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import io.meeds.crowdin.gamification.oauth.CrowdinApi;
import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdinConnectorPlugin
extends ConnectorPlugin {
    private static final Log LOG = ExoLogger.getLogger(CrowdinConnectorPlugin.class);
    private static final String CONNECTOR_NAME = "crowdin";
    private static final String NAME = "crowdin";
    private static final String CONNECTOR_REST_API = "https://api.crowdin.com/api/v2/user";
    private static final String CONNECTOR_SCOPE = "notification";
    private OAuth20Service oAuthService;
    private long remoteConnectorId;
    @Autowired
    private ConnectorSettingService connectorSettingService;
    @Autowired
    private ConnectorService connectorService;

    @PostConstruct
    public void initData() {
        this.connectorService.addPlugin((ConnectorPlugin)this);
    }

    public String getConnectorName() {
        return "crowdin";
    }

    public String getName() {
        return "crowdin";
    }

    public String validateToken(String code) throws OAuthException {
        RemoteConnectorSettings remoteConnectorSettings = this.connectorSettingService.getConnectorSettings("crowdin");
        remoteConnectorSettings.setSecretKey(this.connectorSettingService.getConnectorSecretKey("crowdin"));
        if (StringUtils.isBlank((CharSequence)remoteConnectorSettings.getApiKey()) || StringUtils.isBlank((CharSequence)remoteConnectorSettings.getSecretKey())) {
            LOG.warn("Missing '{}' connector settings", new Object[]{"crowdin"});
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)code)) {
            try {
                OAuth2AccessToken oAuth2AccessToken = this.getOAuthService(remoteConnectorSettings).getAccessToken(code);
                String crowdinIdentifier = CrowdinConnectorPlugin.fetchUsernameFromAccessToken(oAuth2AccessToken.getAccessToken());
                if (StringUtils.isBlank((CharSequence)crowdinIdentifier)) {
                    throw new OAuthException(OAuthExceptionCode.INVALID_STATE, "User Crowdin identifier is empty");
                }
                return crowdinIdentifier;
            }
            catch (IOException | InterruptedException e) {
                throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, (Throwable)e);
            }
        }
        throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, "User denied scope on Crowdin authorization page");
    }

    private static String fetchUsernameFromAccessToken(String accessToken) throws IOException {
        URL url = new URL(CONNECTOR_REST_API);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Authorization", "Bearer " + accessToken);
        connection.setRequestProperty("Accept", "application/json");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                String string = response.toString().split("\"username\":")[1].split(",")[0].replace("\"", "").trim();
                return string;
            }
        }
        throw new IOException("Error retrieving user information from Crowdin. Response code: " + responseCode);
    }

    public OAuth20Service getOAuthService(RemoteConnectorSettings remoteConnectorSettings) {
        if (this.oAuthService == null || (long)remoteConnectorSettings.hashCode() != this.remoteConnectorId) {
            this.remoteConnectorId = remoteConnectorSettings.hashCode();
            this.oAuthService = new ServiceBuilder(remoteConnectorSettings.getApiKey()).apiSecret(remoteConnectorSettings.getSecretKey()).callback(remoteConnectorSettings.getRedirectUrl()).defaultScope(CONNECTOR_SCOPE).build((DefaultApi20)CrowdinApi.instance());
        }
        return this.oAuthService;
    }
}

