/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.test;

import jakarta.servlet.ServletContext;
import java.net.URL;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;

public class MockConfigurationManagerImpl
extends ConfigurationManagerImpl {
    private String confDir_ = System.getProperty("mock.portal.dir") + "/WEB-INF";

    public MockConfigurationManagerImpl(ServletContext context) throws Exception {
        super(context, ExoContainer.getProfilesFromProperty());
    }

    @Override
    public URL getURL(String uri) throws Exception {
        if (uri.startsWith("jar:")) {
            String path = this.removePrefix("jar:", uri);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String finalPath = path;
            return cl.getResource(finalPath);
        }
        if (uri.startsWith("classpath:")) {
            String path = this.removePrefix("classpath:", uri);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return Thread.currentThread().getContextClassLoader().getResource(path);
        }
        if (uri.startsWith("war:")) {
            String path = this.removePrefix("war:", uri);
            URL url = new URL("file:" + this.confDir_ + path);
            return url;
        }
        if (uri.startsWith("file:")) {
            return new URL(uri);
        }
        return null;
    }
}

