/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public final class Template {
    private static final Set<String> KEYWORDS = new HashSet<String>();
    private static final Set<String> BEFORE_TABLE_KEYWORDS = new HashSet<String>();
    private static final Set<String> FUNCTION_KEYWORDS = new HashSet<String>();
    private static final Set<String> LITERAL_PREFIXES = new HashSet<String>();
    public static final String PUNCTUATION = "=><!+-*/()',|&`";
    public static final String TEMPLATE = "$PlaceHolder$";

    private Template() {
    }

    public static String renderTransformerReadFragment(String fragment, String ... columnNames) {
        for (String columnName : columnNames) {
            fragment = fragment.replace(columnName, "$PlaceHolder$." + columnName);
        }
        return fragment;
    }

    public static String renderWhereStringTemplate(String sqlWhereString, Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
        return Template.renderWhereStringTemplate(sqlWhereString, TEMPLATE, dialect, typeConfiguration, functionRegistry);
    }

    public static String renderWhereStringTemplate(String sqlWhereString, String placeholder, Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
        String nextToken;
        String symbols = "=><!+-*/()',|&` \n\r\f\t" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer tokens = new StringTokenizer(sqlWhereString, symbols, true);
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        boolean quotedIdentifier = false;
        boolean beforeTable = false;
        boolean inFromClause = false;
        boolean afterFromTable = false;
        boolean hasMore = tokens.hasMoreTokens();
        String string = nextToken = hasMore ? tokens.nextToken() : null;
        while (hasMore) {
            boolean quotedOrWhitespace;
            String token = nextToken;
            String lcToken = token.toLowerCase(Locale.ROOT);
            hasMore = tokens.hasMoreTokens();
            nextToken = hasMore ? tokens.nextToken() : null;
            boolean isQuoteCharacter = false;
            if (!quotedIdentifier && "'".equals(token)) {
                quoted = !quoted;
                isQuoteCharacter = true;
            }
            if (!quoted) {
                boolean isOpenQuote;
                if ("`".equals(token)) {
                    isOpenQuote = !quotedIdentifier;
                    lcToken = isOpenQuote ? Character.toString(dialect.openQuote()) : Character.toString(dialect.closeQuote());
                    token = lcToken;
                    quotedIdentifier = isOpenQuote;
                    isQuoteCharacter = true;
                } else if (!quotedIdentifier && dialect.openQuote() == token.charAt(0)) {
                    isOpenQuote = true;
                    quotedIdentifier = true;
                    isQuoteCharacter = true;
                } else if (quotedIdentifier && dialect.closeQuote() == token.charAt(0)) {
                    quotedIdentifier = false;
                    isQuoteCharacter = true;
                    isOpenQuote = false;
                } else {
                    isOpenQuote = false;
                }
                if (isOpenQuote) {
                    result.append(placeholder).append('.');
                }
            }
            boolean bl = quotedOrWhitespace = quoted || quotedIdentifier || isQuoteCharacter || token.isBlank();
            if (quotedOrWhitespace) {
                result.append(token);
            } else if (beforeTable) {
                result.append(token);
                beforeTable = false;
                afterFromTable = true;
            } else if (afterFromTable) {
                if (!"as".equals(lcToken)) {
                    afterFromTable = false;
                }
                result.append(token);
            } else if (Template.isNamedParameter(token)) {
                result.append(token);
            } else if (Template.isExtractFunction(lcToken, nextToken)) {
                Template.handleExtractFunction(placeholder, dialect, typeConfiguration, functionRegistry, tokens, result);
                hasMore = tokens.hasMoreTokens();
                nextToken = hasMore ? tokens.nextToken() : null;
            } else if (Template.isTrimFunction(lcToken, nextToken)) {
                Template.handleTrimFunction(placeholder, dialect, typeConfiguration, functionRegistry, tokens, result);
                hasMore = tokens.hasMoreTokens();
                nextToken = hasMore ? tokens.nextToken() : null;
            } else if (Template.isIdentifier(token) && !Template.isFunctionOrKeyword(lcToken, nextToken, dialect, typeConfiguration, functionRegistry) && !Template.isLiteral(lcToken, nextToken, sqlWhereString, symbols, tokens)) {
                result.append(placeholder).append('.').append(dialect.quote(token));
            } else {
                if (BEFORE_TABLE_KEYWORDS.contains(lcToken)) {
                    beforeTable = true;
                    inFromClause = true;
                } else if (inFromClause && ",".equals(lcToken)) {
                    beforeTable = true;
                }
                if (Template.isBoolean(token)) {
                    token = dialect.toBooleanValueString(Boolean.parseBoolean(token));
                }
                result.append(token);
            }
            if (!inFromClause || !KEYWORDS.contains(lcToken) || BEFORE_TABLE_KEYWORDS.contains(lcToken)) continue;
            inFromClause = false;
        }
        return result.toString();
    }

    private static boolean isTrimFunction(String lcToken, String nextToken) {
        return "trim".equals(lcToken) && "(".equals(nextToken);
    }

    private static boolean isExtractFunction(String lcToken, String nextToken) {
        return "extract".equals(lcToken) && "(".equals(nextToken);
    }

    private static boolean isLiteral(String lcToken, String next, String sqlWhereString, String symbols, StringTokenizer tokens) {
        if (LITERAL_PREFIXES.contains(lcToken) && next != null) {
            if ("'".equals(next)) {
                return true;
            }
            if (!next.isBlank()) {
                return false;
            }
            StringTokenizer lookahead = new StringTokenizer(sqlWhereString, symbols, true);
            while (lookahead.countTokens() > tokens.countTokens() + 1) {
                lookahead.nextToken();
            }
            if (lookahead.hasMoreTokens()) {
                String nextToken;
                while ((nextToken = lookahead.nextToken().toLowerCase(Locale.ROOT)).isBlank() && lookahead.hasMoreTokens()) {
                }
                return "'".equals(nextToken) || lcToken.equals("time") && "with".equals(nextToken) || lcToken.equals("timestamp") && "with".equals(nextToken) || lcToken.equals("time") && "zone".equals(nextToken);
            }
            return false;
        }
        return false;
    }

    private static void handleTrimFunction(String placeholder, Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry, StringTokenizer tokens, StringBuilder result) {
        ArrayList<String> operands = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean hasMoreOperands = true;
        String operandToken = tokens.nextToken();
        switch (operandToken.toLowerCase(Locale.ROOT)) {
            case "leading": 
            case "trailing": 
            case "both": {
                operands.add(operandToken);
                hasMoreOperands = tokens.hasMoreTokens();
                if (!hasMoreOperands) break;
                operandToken = tokens.nextToken();
            }
        }
        boolean quotedOperand = false;
        int parenthesis = 0;
        while (hasMoreOperands) {
            boolean isQuote = "'".equals(operandToken);
            if (isQuote) {
                boolean bl = quotedOperand = !quotedOperand;
                if (!quotedOperand) {
                    operands.add(builder.append('\'').toString());
                    builder.setLength(0);
                } else {
                    builder.append('\'');
                }
            } else if (quotedOperand) {
                builder.append(operandToken);
            } else if (parenthesis != 0) {
                builder.append(operandToken);
                switch (operandToken) {
                    case "(": {
                        ++parenthesis;
                        break;
                    }
                    case ")": {
                        --parenthesis;
                    }
                }
            } else {
                builder.append(operandToken);
                switch (operandToken.toLowerCase(Locale.ROOT)) {
                    case "(": {
                        ++parenthesis;
                        break;
                    }
                    case ")": {
                        --parenthesis;
                        break;
                    }
                    case "from": {
                        if (builder.length() == 0) break;
                        operands.add(builder.substring(0, builder.length() - 4));
                        builder.setLength(0);
                        operands.add(operandToken);
                    }
                }
            }
            operandToken = tokens.nextToken();
            hasMoreOperands = tokens.hasMoreTokens() && (parenthesis != 0 || !")".equals(operandToken));
        }
        if (builder.length() != 0) {
            operands.add(builder.toString());
        }
        TrimOperands trimOperands = new TrimOperands(operands);
        result.append("trim(");
        if (trimOperands.trimSpec != null) {
            result.append(trimOperands.trimSpec).append(' ');
        }
        if (trimOperands.trimChar != null) {
            if (trimOperands.trimChar.startsWith("'") && trimOperands.trimChar.endsWith("'")) {
                result.append(trimOperands.trimChar);
            } else {
                result.append(Template.renderWhereStringTemplate(trimOperands.trimSpec, placeholder, dialect, typeConfiguration, functionRegistry));
            }
            result.append(' ');
        }
        if (trimOperands.from != null) {
            result.append(trimOperands.from).append(' ');
        } else if (trimOperands.trimSpec != null || trimOperands.trimChar != null) {
            result.append("from ");
        }
        result.append(Template.renderWhereStringTemplate(trimOperands.trimSource, placeholder, dialect, typeConfiguration, functionRegistry)).append(')');
    }

    private static void handleExtractFunction(String placeholder, Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry, StringTokenizer tokens, StringBuilder result) {
        String field = Template.extractUntil(tokens, "from");
        String source = Template.renderWhereStringTemplate(Template.extractUntil(tokens, ")"), placeholder, dialect, typeConfiguration, functionRegistry);
        result.append("extract(").append(field).append(" from ").append(source).append(')');
    }

    public static List<String> collectColumnNames(String sql, Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
        return Template.collectColumnNames(Template.renderWhereStringTemplate(sql, dialect, typeConfiguration, functionRegistry));
    }

    public static List<String> collectColumnNames(String template) {
        int match;
        ArrayList<String> names = new ArrayList<String>();
        int begin = 0;
        block0: while ((match = template.indexOf(TEMPLATE, begin)) >= 0) {
            int start;
            int loc = start = match + TEMPLATE.length() + 1;
            while (true) {
                if (loc == template.length() - 1) {
                    names.add(template.substring(start));
                    begin = template.length();
                    continue block0;
                }
                char ch = template.charAt(loc);
                if (PUNCTUATION.indexOf(ch) >= 0 || " \n\r\f\t".indexOf(ch) >= 0) {
                    names.add(template.substring(start, loc));
                    begin = loc;
                    continue block0;
                }
                ++loc;
            }
        }
        return names;
    }

    private static String extractUntil(StringTokenizer tokens, String delimiter) {
        StringBuilder valueBuilder = new StringBuilder();
        String token = tokens.nextToken();
        while (!delimiter.equalsIgnoreCase(token)) {
            valueBuilder.append(token);
            token = tokens.nextToken();
        }
        return valueBuilder.toString().trim();
    }

    private static boolean isNamedParameter(String token) {
        return token.startsWith(":");
    }

    private static boolean isFunctionOrKeyword(String lcToken, String nextToken, Dialect dialect, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
        if ("(".equals(nextToken)) {
            return true;
        }
        if ("date".equals(lcToken) || "time".equals(lcToken)) {
            return false;
        }
        return KEYWORDS.contains(lcToken) || Template.isType(lcToken, typeConfiguration) || Template.isFunction(lcToken, nextToken, functionRegistry) || dialect.getKeywords().contains(lcToken) || FUNCTION_KEYWORDS.contains(lcToken);
    }

    private static boolean isType(String lcToken, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getDdlTypeRegistry().isTypeNameRegistered(lcToken);
    }

    private static boolean isFunction(String lcToken, String nextToken, SqmFunctionRegistry functionRegistry) {
        if ("(".equals(nextToken)) {
            return true;
        }
        SqmFunctionDescriptor function = functionRegistry.findFunctionDescriptor(lcToken);
        return function != null;
    }

    private static boolean isIdentifier(String token) {
        if (Template.isBoolean(token)) {
            return false;
        }
        return token.charAt(0) == '`' || Character.isLetter(token.charAt(0)) && token.indexOf(46) < 0;
    }

    private static boolean isBoolean(String token) {
        return "true".equals(token) || "false".equals(token);
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("escape");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
        KEYWORDS.add("select");
        KEYWORDS.add("distinct");
        KEYWORDS.add("from");
        KEYWORDS.add("join");
        KEYWORDS.add("inner");
        KEYWORDS.add("outer");
        KEYWORDS.add("left");
        KEYWORDS.add("right");
        KEYWORDS.add("on");
        KEYWORDS.add("where");
        KEYWORDS.add("having");
        KEYWORDS.add("group");
        KEYWORDS.add("order");
        KEYWORDS.add("by");
        KEYWORDS.add("desc");
        KEYWORDS.add("asc");
        KEYWORDS.add("limit");
        KEYWORDS.add("any");
        KEYWORDS.add("some");
        KEYWORDS.add("exists");
        KEYWORDS.add("all");
        KEYWORDS.add("union");
        KEYWORDS.add("minus");
        KEYWORDS.add("except");
        KEYWORDS.add("intersect");
        KEYWORDS.add("partition");
        BEFORE_TABLE_KEYWORDS.add("from");
        BEFORE_TABLE_KEYWORDS.add("join");
        FUNCTION_KEYWORDS.add("as");
        FUNCTION_KEYWORDS.add("leading");
        FUNCTION_KEYWORDS.add("trailing");
        FUNCTION_KEYWORDS.add("from");
        FUNCTION_KEYWORDS.add("case");
        FUNCTION_KEYWORDS.add("when");
        FUNCTION_KEYWORDS.add("then");
        FUNCTION_KEYWORDS.add("else");
        FUNCTION_KEYWORDS.add("end");
        LITERAL_PREFIXES.add("n");
        LITERAL_PREFIXES.add("x");
        LITERAL_PREFIXES.add("varbyte");
        LITERAL_PREFIXES.add("bx");
        LITERAL_PREFIXES.add("bytea");
        LITERAL_PREFIXES.add("date");
        LITERAL_PREFIXES.add("time");
        LITERAL_PREFIXES.add("timestamp");
        LITERAL_PREFIXES.add("zone");
    }

    private static class TrimOperands {
        private final String trimSpec;
        private final String trimChar;
        private final String from;
        private final String trimSource;

        private TrimOperands(List<String> operands) {
            int size = operands.size();
            if (size == 1) {
                this.trimSpec = null;
                this.trimChar = null;
                this.from = null;
                this.trimSource = operands.get(0);
            } else if (size == 4) {
                this.trimSpec = operands.get(0);
                this.trimChar = operands.get(1);
                this.from = operands.get(2);
                this.trimSource = operands.get(3);
            } else {
                if (size < 1 || size > 4) {
                    throw new HibernateException("Unexpected number of trim function operands : " + size);
                }
                this.trimSource = operands.get(size - 1);
                if (!"from".equals(operands.get(size - 2))) {
                    throw new HibernateException("Expecting FROM, found : " + operands.get(size - 2));
                }
                this.from = operands.get(size - 2);
                if ("leading".equalsIgnoreCase(operands.get(0)) || "trailing".equalsIgnoreCase(operands.get(0)) || "both".equalsIgnoreCase(operands.get(0))) {
                    this.trimSpec = operands.get(0);
                    this.trimChar = null;
                } else {
                    this.trimSpec = null;
                    this.trimChar = size - 2 == 0 ? null : operands.get(0);
                }
            }
        }
    }
}

