/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.security.rest;

import io.meeds.web.security.service.OtpService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/otp"})
@Tag(name="/otp", description="Manage User API Keys")
public class OtpRest {
    @Autowired
    private OtpService otpService;

    @GetMapping
    @Secured(value={"users"})
    @ResponseStatus(code=HttpStatus.NO_CONTENT)
    @Operation(summary="Sends an OTP code using the designated method (email, app ...)", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fullfilled")})
    public void sendOtpCode(HttpServletRequest request, @Parameter(description="OTP Method") @RequestParam(value="method") String otpMethod) {
        this.otpService.sendOtpCode(request.getRemoteUser(), otpMethod);
    }
}

