/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.regexp;

import org.exoplatform.web.controller.regexp.GroupType;
import org.exoplatform.web.controller.regexp.Quantifier;
import org.exoplatform.web.controller.regexp.REVisitor;

public abstract class RENode {
    private Ref<?> owner;

    public abstract String toString();

    public abstract <E extends Exception> void accept(REVisitor<E> var1) throws E;

    public final RENode getParent() {
        return this.owner != null ? this.owner.parent : null;
    }

    public final RENode getRoot() {
        RENode root = this;
        RENode parent = root.getParent();
        while (parent != null) {
            root = parent;
            parent = root.getParent();
        }
        return root;
    }

    public final RENode replaceBy(RENode that) throws IllegalStateException {
        if (this.owner == null) {
            throw new IllegalStateException("Not attached");
        }
        return this.owner.replace(that);
    }

    protected abstract class Ref<N extends RENode> {
        private final Class<N> type;
        private final RENode parent;

        protected Ref(RENode this$0, RENode parent, Class<N> type) {
            this.parent = parent;
            this.type = type;
        }

        public final Class<N> getType() {
            return this.type;
        }

        protected abstract N set(N var1);

        protected abstract N get();

        protected final boolean isNull() {
            return this.get() == null;
        }

        protected final boolean isNotNull() {
            return this.get() != null;
        }

        protected final N replace(RENode that) {
            if (that == null || this.type.isInstance(that)) {
                return (N)this.set((RENode)this.type.cast(that));
            }
            throw new ClassCastException("Cannot cast node with type " + that.getClass().getName() + " to type " + this.type.getName());
        }
    }

    protected class NonNullableRef<N extends RENode>
    extends Ref<N> {
        private N node;

        public NonNullableRef(RENode parent, Class<N> type, N node) {
            super(this$0, parent, type);
            if (node == null) {
                throw new NullPointerException("No null node accepted");
            }
            if (((RENode)node).owner != null) {
                throw new IllegalArgumentException();
            }
            ((RENode)node).owner = this;
            this.node = node;
        }

        @Override
        protected N set(N node) {
            if (node == null) {
                throw new NullPointerException("No null node accepted");
            }
            if (((RENode)node).owner != null) {
                throw new IllegalArgumentException();
            }
            N previous = this.node;
            ((RENode)this.node).owner = null;
            ((RENode)node).owner = this;
            this.node = node;
            return previous;
        }

        @Override
        protected N get() {
            return this.node;
        }
    }

    protected class NullableRef<N extends RENode>
    extends Ref<N> {
        private N node;

        public NullableRef(RENode this$0, RENode parent, Class<N> type) {
            this(this$0, parent, type, null);
        }

        public NullableRef(RENode parent, Class<N> type, N node) {
            super(this$0, parent, type);
            if (node != null) {
                if (((RENode)node).owner != null) {
                    throw new IllegalArgumentException();
                }
                ((RENode)node).owner = this;
            }
            this.node = node;
        }

        @Override
        protected N set(N node) {
            if (node != null && ((RENode)node).owner != null) {
                throw new IllegalArgumentException();
            }
            N previous = this.node;
            if (this.node != null) {
                ((RENode)this.node).owner = null;
            }
            if (node != null) {
                ((RENode)node).owner = this;
                this.node = node;
            } else {
                this.node = null;
            }
            return previous;
        }

        @Override
        protected N get() {
            return this.node;
        }
    }

    public static abstract class CharacterClassExpr
    extends RENode {
        private CharacterClassExpr() {
        }

        public CharacterClassExpr remove(char c) {
            throw new UnsupportedOperationException();
        }

        public CharacterClassExpr replace(char src, char dst) {
            throw new UnsupportedOperationException();
        }

        public static class Range
        extends CharacterClassExpr {
            private Char from;
            private Char to;

            public Range(Char from, Char to) {
                if (from.value > to.value) {
                    throw new IllegalArgumentException("From cannot be greater or equals than to");
                }
                this.from = from;
                this.to = to;
            }

            @Override
            public CharacterClassExpr remove(char c) throws IllegalArgumentException {
                if (this.from.value == this.to.value) {
                    if (this.from.value == c) {
                        throw new UnsupportedOperationException();
                    }
                } else {
                    if (this.from.value + '\u0001' == this.to.value) {
                        if (this.from.value == c) {
                            Char repl = new Char(this.to.value);
                            this.replaceBy(repl);
                            return repl;
                        }
                        Char repl = new Char(this.from.value);
                        this.replaceBy(repl);
                        return repl;
                    }
                    if (this.from.value == c) {
                        this.from.value = (char)(this.from.value + '\u0001');
                    } else if (this.to.value == c) {
                        this.to.value = (char)(this.to.value - '\u0001');
                    } else if (this.from.value < c && c < this.to.value) {
                        CharacterClassExpr left = this.from.value + '\u0001' == c ? new Char(this.from.value) : new Range(this.from, new Char((char)(c - '\u0001')));
                        CharacterClassExpr right = c == this.to.value - '\u0001' ? new Char(this.to.value) : new Range(new Char((char)(c + '\u0001')), this.to);
                        Or repl = new Or(left, right);
                        this.replaceBy(repl);
                        return repl;
                    }
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                CharacterClassExpr repl = this.remove(src);
                if (repl != this) {
                    Or or = new Or(null, new Char(dst));
                    repl.replaceBy(or);
                    or.setLeft(repl);
                    repl = or;
                }
                return repl;
            }

            public Char getFrom() {
                return this.from;
            }

            public Char getTo() {
                return this.to;
            }

            @Override
            public String toString() {
                return "[" + this.from.value + "-" + this.to.value + "]";
            }

            @Override
            public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
                visitor.visit(this);
            }
        }

        public static class Char
        extends CharacterClassExpr {
            private char value;

            public Char(char value) {
                this.value = value;
            }

            public char getValue() {
                return this.value;
            }

            public void setValue(char value) {
                this.value = value;
            }

            @Override
            public CharacterClassExpr remove(char c) {
                if (c == this.value) {
                    this.replaceBy(null);
                    return null;
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                if (src == this.value) {
                    this.value = dst;
                }
                return this;
            }

            @Override
            public String toString() {
                return "[" + this.value + "]";
            }

            @Override
            public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
                visitor.visit(this);
            }
        }

        public static class And
        extends CharacterClassExpr {
            private final Ref<CharacterClassExpr> left;
            private final Ref<CharacterClassExpr> right;

            public And(CharacterClassExpr left, CharacterClassExpr right) {
                this.left = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)left);
                this.right = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)right);
            }

            public CharacterClassExpr getLeft() {
                return this.left.get();
            }

            public void setLeft(CharacterClassExpr left) {
                this.left.set(left);
            }

            public CharacterClassExpr getRight() {
                return this.right.get();
            }

            public void setRight(CharacterClassExpr right) {
                this.right.set(right);
            }

            @Override
            public CharacterClassExpr remove(char c) {
                if (this.left.isNotNull()) {
                    this.left.get().remove(c);
                }
                if (this.right.isNotNull()) {
                    this.right.get().remove(c);
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                if (this.left.isNotNull()) {
                    this.left.get().replace(src, dst);
                }
                if (this.right.isNotNull()) {
                    this.right.get().replace(src, dst);
                }
                return this;
            }

            @Override
            public String toString() {
                String l = this.left.isNotNull() ? this.left.get().toString() : "";
                String r = this.right.isNotNull() ? this.right.get().toString() : "";
                return "[" + l + "&&" + r + "]";
            }

            @Override
            public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
                visitor.visit(this);
            }
        }

        public static class Or
        extends CharacterClassExpr {
            private final Ref<CharacterClassExpr> left;
            private final Ref<CharacterClassExpr> right;

            public Or(CharacterClassExpr left, CharacterClassExpr right) {
                this.left = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)left);
                this.right = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)right);
            }

            public CharacterClassExpr getLeft() {
                return this.left.get();
            }

            public void setLeft(CharacterClassExpr left) {
                this.left.set(left);
            }

            public CharacterClassExpr getRight() {
                return this.right.get();
            }

            public void setRight(CharacterClassExpr right) {
                this.right.set(right);
            }

            @Override
            public CharacterClassExpr remove(char c) {
                if (this.left.isNotNull()) {
                    this.left.get().remove(c);
                }
                if (this.right.isNotNull()) {
                    this.right.get().remove(c);
                }
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                if (this.left.isNotNull()) {
                    this.left.get().replace(src, dst);
                }
                if (this.right.isNotNull()) {
                    this.right.get().replace(src, dst);
                }
                return this;
            }

            @Override
            public String toString() {
                String l = this.left.isNotNull() ? this.left.get().toString() : "";
                String r = this.right.isNotNull() ? this.right.get().toString() : "";
                return "[" + l + "||" + r + "]";
            }

            @Override
            public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
                visitor.visit(this);
            }
        }

        public static class Not
        extends CharacterClassExpr {
            private final Ref<CharacterClassExpr> negated;

            public Not(CharacterClassExpr negated) {
                this.negated = new NullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)negated);
            }

            public CharacterClassExpr getNegated() {
                return this.negated.get();
            }

            public void setNegated(CharacterClassExpr negated) {
                this.negated.set(negated);
            }

            @Override
            public CharacterClassExpr remove(char c) {
                this.negated.get().remove(c);
                return this;
            }

            @Override
            public CharacterClassExpr replace(char src, char dst) {
                this.negated.get().replace(src, dst);
                return this;
            }

            @Override
            public String toString() {
                return "[^" + String.valueOf(this.negated.get()) + "]";
            }

            @Override
            public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
                visitor.visit(this);
            }
        }
    }

    public static class CharacterClass
    extends Atom {
        private final Ref<CharacterClassExpr> expr;

        public CharacterClass(CharacterClassExpr expr) {
            this.expr = new NonNullableRef((RENode)this, (RENode)this, CharacterClassExpr.class, (RENode)expr);
        }

        public CharacterClassExpr getExpr() {
            return this.expr.get();
        }

        public void setExpr(CharacterClassExpr expr) {
            this.expr.set(expr);
        }

        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append(this.expr.get());
        }

        @Override
        public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
            visitor.visit(this);
        }
    }

    public static final class Char
    extends Atom {
        private char value;

        public Char(char value) {
            this.value = value;
        }

        public char getValue() {
            return this.value;
        }

        public void setValue(char value) {
            this.value = value;
        }

        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append("<c>").append(this.value).append("</c>");
        }

        @Override
        public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
            visitor.visit(this);
        }
    }

    public static final class Any
    extends Atom {
        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append("<./>");
        }

        @Override
        public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
            visitor.visit(this);
        }
    }

    public static abstract class Atom
    extends Expr {
        private Atom() {
        }
    }

    public static final class Group
    extends Expr {
        private GroupType type;
        private final Ref<Disjunction> disjunction;

        public Group(Disjunction disjunction, GroupType type) throws NullPointerException {
            if (type == null) {
                throw new NullPointerException("No null type accepted");
            }
            this.disjunction = new NullableRef((RENode)this, (RENode)this, Disjunction.class, (RENode)disjunction);
            this.type = type;
        }

        public Disjunction getDisjunction() {
            return this.disjunction.get();
        }

        public void setDisjunction(Disjunction disjunction) {
            this.disjunction.set(disjunction);
        }

        public GroupType getType() {
            return this.type;
        }

        public void setType(GroupType type) {
            this.type = type;
        }

        @Override
        protected void writeTo(StringBuilder sb) {
            sb.append("<").append(this.type.getOpen()).append('>').append(this.disjunction.get()).append("</").append(this.type.getOpen()).append(">");
        }

        @Override
        public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
            visitor.visit(this);
        }
    }

    public static abstract class Assertion
    extends Expr {
        private Assertion() {
        }

        public static final class End
        extends Assertion {
            @Override
            protected void writeTo(StringBuilder sb) {
                sb.append("<$/>");
            }

            @Override
            public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
                visitor.visit(this);
            }
        }

        public static final class Begin
        extends Assertion {
            @Override
            protected void writeTo(StringBuilder sb) {
                sb.append("<^/>");
            }

            @Override
            public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
                visitor.visit(this);
            }
        }
    }

    public static abstract class Expr
    extends RENode {
        private Quantifier quantifier;

        private Expr() {
        }

        public final int getMin() {
            return this.quantifier == null ? 1 : this.quantifier.getMin();
        }

        public final Quantifier getQuantifier() {
            return this.quantifier;
        }

        public final void setQuantifier(Quantifier quantifier) {
            this.quantifier = quantifier;
        }

        @Override
        public final String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.quantifier != null) {
                String q = this.quantifier.toString();
                sb.append('<').append(q).append('>');
                this.writeTo(sb);
                sb.append("</").append(q).append('>');
            } else {
                this.writeTo(sb);
            }
            return sb.toString();
        }

        protected abstract void writeTo(StringBuilder var1);
    }

    public static final class Alternative
    extends RENode {
        private final Ref<Expr> expr;
        private final Ref<Alternative> next;

        public Alternative(Expr expr) {
            this(expr, null);
        }

        public Alternative(Expr expr, Alternative next) {
            this.expr = new NonNullableRef((RENode)this, (RENode)this, Expr.class, (RENode)expr);
            this.next = new NullableRef((RENode)this, (RENode)this, Alternative.class, (RENode)next);
        }

        public Expr getExpr() {
            return this.expr.get();
        }

        public void setExpr(Expr expr) {
            this.expr.set(expr);
        }

        public Alternative getNext() {
            return this.next.get();
        }

        public void setNext(Alternative next) {
            this.next.set(next);
        }

        @Override
        public String toString() {
            if (this.next.isNotNull()) {
                return this.expr.get().toString() + String.valueOf(this.next.get());
            }
            return this.expr.get().toString();
        }

        @Override
        public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
            visitor.visit(this);
        }
    }

    public static final class Disjunction
    extends RENode {
        private NullableRef<Alternative> alternative;
        private NullableRef<Disjunction> next;

        public Disjunction() {
            this.alternative = null;
            this.next = null;
        }

        public Disjunction(Alternative alternative) {
            this.alternative = new NullableRef((RENode)this, (RENode)this, Alternative.class, (RENode)alternative);
            this.next = null;
        }

        public Disjunction(Alternative alternative, Disjunction next) {
            this.alternative = new NullableRef((RENode)this, (RENode)this, Alternative.class, (RENode)alternative);
            this.next = new NullableRef((RENode)this, (RENode)this, Disjunction.class, (RENode)next);
        }

        public Disjunction(Disjunction next) {
            this.alternative = null;
            this.next = new NullableRef((RENode)this, (RENode)this, Disjunction.class, (RENode)next);
        }

        public Alternative getAlternative() {
            return this.alternative != null ? this.alternative.get() : null;
        }

        public void setAlternative(Alternative alternative) {
            if (this.alternative == null) {
                this.alternative = new NullableRef((RENode)this, (RENode)this, Alternative.class, (RENode)alternative);
            } else {
                this.alternative.set(alternative);
            }
        }

        public boolean hasAlternative() {
            return this.alternative != null;
        }

        public void clearAlternative() {
            if (this.alternative != null) {
                this.alternative.set(null);
                this.alternative = null;
            }
        }

        public Disjunction getNext() {
            return this.next != null ? this.next.get() : null;
        }

        public void setNext(Disjunction next) {
            if (this.next == null) {
                this.next = new NullableRef((RENode)this, (RENode)this, Disjunction.class, (RENode)next);
            } else {
                this.next.set(next);
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void clearNext() {
            if (this.next != null) {
                this.next.set(null);
                this.next = null;
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.alternative != null && this.alternative.isNotNull()) {
                sb.append(this.alternative.get());
            }
            if (this.alternative != null && this.next != null) {
                sb.append('|');
            }
            if (this.next != null && this.next.isNotNull()) {
                sb.append(this.next.get());
            }
            return sb.toString();
        }

        @Override
        public <E extends Exception> void accept(REVisitor<E> visitor) throws E {
            visitor.visit(this);
        }
    }
}

