/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.FilteringValidation;
import co.elastic.clients.elasticsearch.connector.FilteringValidationState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FilteringRulesValidation
implements JsonpSerializable {
    private final List<FilteringValidation> errors;
    private final FilteringValidationState state;
    public static final JsonpDeserializer<FilteringRulesValidation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilteringRulesValidation::setupFilteringRulesValidationDeserializer);

    private FilteringRulesValidation(Builder builder) {
        this.errors = ApiTypeHelper.unmodifiableRequired(builder.errors, (Object)this, "errors");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static FilteringRulesValidation of(Function<Builder, ObjectBuilder<FilteringRulesValidation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FilteringValidation> errors() {
        return this.errors;
    }

    public final FilteringValidationState state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.errors)) {
            generator.writeKey("errors");
            generator.writeStartArray();
            for (FilteringValidation item0 : this.errors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFilteringRulesValidationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::errors, JsonpDeserializer.arrayDeserializer(FilteringValidation._DESERIALIZER), "errors");
        op.add(Builder::state, FilteringValidationState._DESERIALIZER, "state");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilteringRulesValidation> {
        private List<FilteringValidation> errors;
        private FilteringValidationState state;

        public final Builder errors(List<FilteringValidation> list) {
            this.errors = Builder._listAddAll(this.errors, list);
            return this;
        }

        public final Builder errors(FilteringValidation value, FilteringValidation ... values) {
            this.errors = Builder._listAdd(this.errors, value, values);
            return this;
        }

        public final Builder errors(Function<FilteringValidation.Builder, ObjectBuilder<FilteringValidation>> fn) {
            return this.errors(fn.apply(new FilteringValidation.Builder()).build(), new FilteringValidation[0]);
        }

        public final Builder state(FilteringValidationState value) {
            this.state = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilteringRulesValidation build() {
            this._checkSingleUse();
            return new FilteringRulesValidation(this);
        }
    }
}

