/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.template;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.GroovyElementVisitor;
import org.exoplatform.commons.notification.template.SimpleElementVistior;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class TemplateContentTransformerService {
    private static final String DIGEST_TEMPLATE_KEY = "Digest.%s.%s";
    private static final String SIMPLE_TEMPLATE_KEY = "Simple.%s.%s";
    private ExoCache<String, Element> cacheTemplate;

    public TemplateContentTransformerService(CacheService cacheService) {
        this.cacheTemplate = cacheService.getCacheInstance("commons.subject");
    }

    public String processGroovy(TemplateContext ctx) {
        Element groovyElement = TemplateUtils.loadGroovyElement(ctx.getPluginId(), ctx.getLanguage());
        GroovyElementVisitor visitor = new GroovyElementVisitor();
        return visitor.with(ctx).visit(groovyElement).out();
    }

    public String processSubject(TemplateContext ctx) {
        Element subjectElement = this.getSubjectElement(ctx);
        ctx.forEach((k, v) -> {
            if (v instanceof String) {
                String s = (String)v;
                ctx.put(k, (Object)this.transform(s, ctx));
            }
        });
        String subject = this.getSubject(ctx);
        if (StringUtils.isNotBlank((CharSequence)subject)) {
            ctx.put((Object)"SUBJECT", (Object)TemplateUtils.getExcerptSubject(subject));
            return subjectElement.accept(SimpleElementVistior.instance().with(ctx)).out();
        }
        subject = subjectElement.accept(SimpleElementVistior.instance().with(ctx)).out();
        return TemplateUtils.getExcerptSubject(subject);
    }

    public String processDigest(TemplateContext ctx) {
        DigestTemplate digest = this.getDigestTemplate(ctx);
        return digest.accept(SimpleElementVistior.instance().with(ctx)).out();
    }

    protected String getSubject(TemplateContext ctx) {
        return this.transform((String)ctx.get((Object)"SUBJECT"), ctx);
    }

    protected String transform(String value, TemplateContext ctx) {
        return value == null ? null : StringEscapeUtils.unescapeHtml4((String)value);
    }

    private DigestTemplate getDigestTemplate(TemplateContext ctx) {
        String key = this.getCacheKey(DIGEST_TEMPLATE_KEY, ctx.getPluginId(), ctx.getLanguage());
        DigestTemplate digest = (DigestTemplate)this.cacheTemplate.get((Serializable)((Object)key));
        if (digest == null) {
            PluginConfig templateConfig = TemplateUtils.getPluginConfig(ctx.getPluginId());
            digest = NotificationUtils.getDigest(templateConfig, ctx.getPluginId(), ctx.getLanguage());
            this.cacheTemplate.put((Serializable)((Object)key), (Object)digest);
        }
        return digest;
    }

    private Element getSubjectElement(TemplateContext ctx) {
        String key = this.getCacheKey(SIMPLE_TEMPLATE_KEY, ctx.getPluginId(), ctx.getLanguage());
        Element subjectElement = (Element)this.cacheTemplate.get((Serializable)((Object)key));
        if (subjectElement == null) {
            PluginConfig templateConfig = TemplateUtils.getPluginConfig(ctx.getPluginId());
            subjectElement = NotificationUtils.getSubject(templateConfig, ctx.getPluginId(), ctx.getLanguage()).addNewLine(false);
            this.cacheTemplate.put((Serializable)((Object)key), (Object)subjectElement);
        }
        return subjectElement;
    }

    protected String getCacheKey(String pattern, String pluginId, String language) {
        return String.format(pattern, pluginId, language);
    }
}

