/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.identity.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.core.identity.model.UserExportFilter;
import io.meeds.social.core.identity.model.UserExportResult;
import io.meeds.social.core.identity.service.UserExportService$AjcClosure1;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.search.UserSearchService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserExportService {
    public static final String INTERNAL = "Internal";
    public static final String GUEST = "Guest";
    public static final String DELEGATED_GROUP = "/platform/delegated";
    private static final String CONNECTED = "connected";
    private static final int PAGINATION_PAGE_SIZE = 10;
    protected Map<String, UserExportResult> exportUsersProcessing = new ConcurrentHashMap<String, UserExportResult>();
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private UserSearchService userSearchService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private UserACL userAcl;
    private ExecutorService exportExecutorService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.exportExecutorService = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    public void stop() {
        this.exportExecutorService.shutdownNow();
    }

    public InputStream downloadUsersExport(String exportId, String username) throws IllegalAccessException, ObjectNotFoundException {
        UserExportResult exportResult = this.exportUsersProcessing.get(exportId);
        if (!exportResult.getUsername().equals(username)) {
            throw new IllegalAccessException();
        }
        if (exportResult.isFinished()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(exportResult.retrieveExportPath());
                return fileInputStream;
            }
            catch (FileNotFoundException e) {
                throw new ObjectNotFoundException(String.format("Export users file with id '%s' not found", exportId));
            }
            finally {
                this.exportUsersProcessing.remove(exportId);
            }
        }
        throw new IllegalStateException(String.format("Export users file with id '%s' not finished yet", exportId));
    }

    public UserExportResult getUsersExportResult(String exportId, String username) throws IllegalAccessException {
        UserExportResult exportResult = this.exportUsersProcessing.get(exportId);
        if (!exportResult.getUsername().equals(username)) {
            throw new IllegalAccessException();
        }
        return this.exportUsersProcessing.get(exportId);
    }

    public UserExportResult exportUsers(UserExportFilter exportFilter, String username) {
        this.cleanUpOutdated();
        String exportId = UUID.randomUUID().toString();
        File file = Files.createTempFile(String.format("users-%s_", exportId), ".csv", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        UserExportResult exportResult = new UserExportResult();
        exportResult.setExportId(exportId);
        exportResult.setExportPath(file.getAbsolutePath());
        exportResult.setUsername(username);
        this.exportUsersProcessing.put(exportId, exportResult);
        this.exportUsersAsync(exportFilter, username, exportResult);
        return exportResult;
    }

    protected void exportUsersAsync(UserExportFilter exportFilter, String username, UserExportResult exportResult) {
        this.exportExecutorService.execute(() -> this.exportUsersTransactional(exportFilter, username, exportResult));
    }

    @ContainerTransactional
    protected void exportUsersTransactional(UserExportFilter exportFilter, String username, UserExportResult exportResult) {
        UserExportFilter userExportFilter = exportFilter;
        String string = username;
        UserExportResult userExportResult = exportResult;
        Object[] objectArray = new Object[]{userExportFilter, string, userExportResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, userExportFilter, string, userExportResult, joinPoint};
        UserExportService$AjcClosure1 userExportService$AjcClosure1 = new UserExportService$AjcClosure1(objectArray2);
        ContainerTransactionalAspect.aspectOf().around(userExportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected void exportUsers(UserExportFilter exportFilter, String username, UserExportResult exportResult) {
        int offset = 0;
        int limit = 10;
        File file = new File(exportResult.retrieveExportPath());
        FileOutputStream outputStream = new FileOutputStream(file);
        try (PrintWriter writer = new PrintWriter(outputStream, true, StandardCharsets.UTF_8);){
            org.exoplatform.social.core.identity.model.Identity[] identities;
            writer.write(String.format("userName,firstName,lastName,email,enabled,type,groups%n", new Object[0]));
            while ((identities = this.getUsers(exportFilter, username, offset, limit)) != null && identities.length != 0) {
                for (org.exoplatform.social.core.identity.model.Identity identity : identities) {
                    String userName = identity.getRemoteId();
                    Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(userName);
                    writer.write(String.format("%s,%s,%s,%s,%s,%s,%s%n", userName, identity.getProfile().getProperty("firstName"), identity.getProfile().getProperty("lastName"), identity.getProfile().getEmail(), identity.isEnable() ? "TRUE" : "FALSE", identity.isExternal() ? GUEST : INTERNAL, memberships.stream().map(m -> m.getGroupId()).collect(Collectors.joining(";"))));
                    exportResult.incrementProcessed();
                }
                limit = (offset += limit) + 10;
                if (identities.length >= 10) continue;
            }
            exportResult.setFinished(true);
        }
    }

    private org.exoplatform.social.core.identity.model.Identity[] getUsers(UserExportFilter exportFilter, String username, int offset, int limit) throws Exception {
        org.exoplatform.social.core.identity.model.Identity viewerIdentity = this.identityManager.getOrCreateUserIdentity(username);
        Identity viewerAclIdentity = this.userAcl.getUserIdentity(username);
        ProfileFilter filter = this.computeFilter(exportFilter, viewerIdentity);
        if (CollectionUtils.isNotEmpty((Collection)exportFilter.getIncludeUsers())) {
            boolean delegatedAdminUser = this.isDelegatedAdminUser(filter.getUserType(), viewerAclIdentity);
            List groupIds = delegatedAdminUser ? this.getDelegatedAdminGroups(viewerAclIdentity) : Collections.emptyList();
            return (org.exoplatform.social.core.identity.model.Identity[])exportFilter.getIncludeUsers().stream().filter(StringUtils::isNotBlank).map(arg_0 -> ((IdentityManager)this.identityManager).getOrCreateUserIdentity(arg_0)).filter(Objects::nonNull).filter(i -> !delegatedAdminUser || this.isMemberOf(i.getRemoteId(), groupIds)).skip(offset).limit(limit).toArray(org.exoplatform.social.core.identity.model.Identity[]::new);
        }
        if (this.isDelegatedAdminUser(filter.getUserType(), viewerAclIdentity)) {
            return this.getDelegatedAdminUsers(viewerAclIdentity, exportFilter.getQuery(), exportFilter.isDisabled(), offset, limit);
        }
        if (exportFilter.isDisabled() && StringUtils.isNotBlank((CharSequence)exportFilter.getQuery())) {
            return this.searchUsers(exportFilter.getQuery(), offset, limit);
        }
        return this.loadUsers(filter, offset, limit);
    }

    private ProfileFilter computeFilter(UserExportFilter exportFilter, org.exoplatform.social.core.identity.model.Identity viewerIdentity) {
        ProfileFilter filter = new ProfileFilter();
        this.applySpaceIdsFilter(filter, exportFilter, viewerIdentity);
        this.applySortFilter(filter, exportFilter);
        this.applyExcludeCurrentUserFilter(exportFilter, viewerIdentity, filter);
        this.applyUserPropertiesFilter(filter, exportFilter);
        return filter;
    }

    private void applyExcludeCurrentUserFilter(UserExportFilter userExportFilter, org.exoplatform.social.core.identity.model.Identity viewerIdentity, ProfileFilter filter) {
        if (viewerIdentity != null && userExportFilter.isExcludeCurrentUser()) {
            filter.setViewerIdentity(viewerIdentity);
        }
    }

    private void applySpaceIdsFilter(ProfileFilter filter, UserExportFilter userExportFilter, org.exoplatform.social.core.identity.model.Identity viewerIdentity) {
        List spaceIds = userExportFilter.getSpaceIds();
        if (CollectionUtils.isNotEmpty((Collection)spaceIds)) {
            List<String> spaceIdsString = spaceIds.stream().map(String::valueOf).toList();
            filter.setSpaceIdentityIds(SpaceUtils.getSpaceIdentityIds(viewerIdentity.getRemoteId(), spaceIdsString));
        }
    }

    private void applySortFilter(ProfileFilter filter, UserExportFilter userExportFilter) {
        String sortField = userExportFilter.getSortField();
        String sortDirection = userExportFilter.getSortDirection();
        if (StringUtils.isNotBlank((CharSequence)sortField)) {
            Sorting.SortBy sortBy = Sorting.SortBy.valueOf((String)sortField.toUpperCase());
            Sorting.OrderBy orderBy = Sorting.OrderBy.ASC;
            if (StringUtils.isNotBlank((CharSequence)sortDirection)) {
                orderBy = Sorting.OrderBy.valueOf((String)sortDirection.toUpperCase());
            }
            filter.setSorting(new Sorting(sortBy, orderBy));
        }
    }

    private String applyUserPropertiesFilter(ProfileFilter filter, UserExportFilter userExportFilter) {
        String filterText = userExportFilter.getQuery();
        filter.setName(filterText == null || filterText.isEmpty() ? "" : filterText);
        filter.setSearchEmail(userExportFilter.isSearchEmail());
        filter.setSearchUserName(userExportFilter.isSearchUsername());
        filter.setEnabled(!userExportFilter.isDisabled());
        String userType = userExportFilter.getUserType();
        if (!userExportFilter.isDisabled()) {
            filter.setUserType(userType);
            filter.setConnected(userExportFilter.getIsConnected() != null ? Boolean.valueOf(userExportFilter.getIsConnected().equals(CONNECTED)) : null);
            filter.setEnrollmentStatus(userExportFilter.getEnrollmentStatus());
        }
        return userType;
    }

    private org.exoplatform.social.core.identity.model.Identity[] loadUsers(ProfileFilter filter, int offset, int limit) throws Exception {
        return (org.exoplatform.social.core.identity.model.Identity[])this.identityManager.getIdentitiesByProfileFilter("organization", filter, true).load(offset, limit);
    }

    private org.exoplatform.social.core.identity.model.Identity[] searchUsers(String filterText, int offset, int limit) throws Exception {
        int limitToFetch;
        ListAccess usersListAccess = this.userSearchService.searchUsers(filterText, UserStatus.DISABLED);
        int totalSize = usersListAccess.getSize();
        if (totalSize < offset + (limitToFetch = limit)) {
            limitToFetch = totalSize - offset;
        }
        User[] users = limitToFetch <= 0 ? new User[]{} : (User[])usersListAccess.load(offset, limitToFetch);
        return (org.exoplatform.social.core.identity.model.Identity[])Arrays.stream(users).map(user -> this.identityManager.getOrCreateUserIdentity(user.getUserName())).toArray(org.exoplatform.social.core.identity.model.Identity[]::new);
    }

    private org.exoplatform.social.core.identity.model.Identity[] getDelegatedAdminUsers(Identity userIdentity, String filterText, boolean disabledUsers, int offset, int limit) throws Exception {
        int limitToFetch;
        int totalSize;
        List<String> groupIds = this.getDelegatedAdminGroups(userIdentity);
        ListAccess usersListAccess = null;
        if (CollectionUtils.isNotEmpty(groupIds)) {
            Query query = new Query();
            if (StringUtils.isNotBlank((CharSequence)filterText)) {
                query.setUserName(filterText);
            }
            usersListAccess = this.organizationService.getUserHandler().findUsersByQuery(query, groupIds, disabledUsers ? UserStatus.DISABLED : UserStatus.ENABLED);
        }
        if ((totalSize = usersListAccess == null ? 0 : usersListAccess.getSize()) < offset + (limitToFetch = limit)) {
            limitToFetch = totalSize - offset;
        }
        User[] users = limitToFetch <= 0 || usersListAccess == null ? new User[]{} : (User[])usersListAccess.load(offset, limitToFetch);
        return (org.exoplatform.social.core.identity.model.Identity[])Arrays.stream(users).map(user -> this.identityManager.getOrCreateUserIdentity(user.getUserName())).toArray(org.exoplatform.social.core.identity.model.Identity[]::new);
    }

    private List<String> getDelegatedAdminGroups(Identity userIdentity) {
        return userIdentity.getMemberships().stream().filter(m -> m.getMembershipType().equals("manager") && !m.getGroup().equals(DELEGATED_GROUP) && !m.getGroup().startsWith("/spaces/")).map(MembershipEntry::getGroup).toList();
    }

    private boolean isDelegatedAdminUser(String userType, Identity userAclIdentity) {
        return !this.userAcl.isAdministrator(userAclIdentity) && userAclIdentity.isMemberOf(DELEGATED_GROUP) && userType != null && !userType.equalsIgnoreCase(INTERNAL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMemberOf(String username, List<String> groupIds) {
        Identity userAclIdentity = this.userAcl.getUserIdentity(username);
        if (userAclIdentity == null) return false;
        if (!groupIds.stream().anyMatch(arg_0 -> ((Identity)userAclIdentity).isMemberOf(arg_0))) return false;
        return true;
    }

    private void cleanUpOutdated() {
        Iterator<Map.Entry<String, UserExportResult>> iterator = this.exportUsersProcessing.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, UserExportResult> entry = iterator.next();
            if (!entry.getValue().isOutdated()) continue;
            iterator.remove();
        }
    }

    static {
        UserExportService.ajc$preClinit();
    }

    static final /* synthetic */ void exportUsersTransactional_aroundBody0(UserExportService ajc$this, UserExportFilter exportFilter, String username, UserExportResult exportResult, JoinPoint joinPoint) {
        ajc$this.exportUsers(exportFilter, username, exportResult);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserExportService.java", UserExportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "exportUsersTransactional", "io.meeds.social.core.identity.service.UserExportService", "io.meeds.social.core.identity.model.UserExportFilter:java.lang.String:io.meeds.social.core.identity.model.UserExportResult", "exportFilter:username:exportResult", "", "void"), 168);
    }
}

