/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;

public class GeoJsonMultiPoint
implements GeoJson<Iterable<Point>> {
    public static final String TYPE = "MultiPoint";
    private final List<Point> points;

    private GeoJsonMultiPoint(List<Point> points) {
        this.points = new ArrayList<Point>(points);
    }

    public static GeoJsonMultiPoint of(List<Point> points) {
        Assert.notNull(points, (String)"Points must not be null.");
        Assert.isTrue((points.size() >= 2 ? 1 : 0) != 0, (String)"Minimum of 2 Points required.");
        return new GeoJsonMultiPoint(points);
    }

    public static GeoJsonMultiPoint of(Point first, Point second, Point ... others) {
        Assert.notNull((Object)first, (String)"First point must not be null!");
        Assert.notNull((Object)second, (String)"Second point must not be null!");
        Assert.notNull((Object)others, (String)"Additional points must not be null!");
        ArrayList<Point> points = new ArrayList<Point>(2 + others.length);
        points.add(first);
        points.add(second);
        points.addAll(Arrays.asList(others));
        return new GeoJsonMultiPoint(points);
    }

    public static GeoJsonMultiPoint ofGeoPoints(List<GeoPoint> geoPoints) {
        Assert.notNull(geoPoints, (String)"Points must not be null.");
        Assert.isTrue((geoPoints.size() >= 2 ? 1 : 0) != 0, (String)"Minimum of 2 Points required.");
        return new GeoJsonMultiPoint(geoPoints.stream().map(GeoPoint::toPoint).collect(Collectors.toList()));
    }

    public static GeoJsonMultiPoint of(GeoPoint first, GeoPoint second, GeoPoint ... others) {
        Assert.notNull((Object)first, (String)"First point must not be null!");
        Assert.notNull((Object)second, (String)"Second point must not be null!");
        Assert.notNull((Object)others, (String)"Additional points must not be null!");
        ArrayList<Point> points = new ArrayList<Point>(2 + others.length);
        points.add(GeoPoint.toPoint(first));
        points.add(GeoPoint.toPoint(second));
        points.addAll(Arrays.stream(others).map(GeoPoint::toPoint).collect(Collectors.toList()));
        return new GeoJsonMultiPoint(points);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<Point> getCoordinates() {
        return Collections.unmodifiableList(this.points);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonMultiPoint that = (GeoJsonMultiPoint)o;
        return this.points.equals(that.points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public String toString() {
        return "GeoJsonMultiPoint{points=" + String.valueOf(this.points) + "}";
    }
}

