/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity(name="GateInPermission")
@Table(name="PORTAL_PERMISSIONS")
@NamedQueries(value={@NamedQuery(name="PermissionEntity.deleteByRefId", query="DELETE GateInPermission p WHERE p.referenceType = :refType AND p.referenceId = :refId"), @NamedQuery(name="PermissionEntity.getPermissions", query="SELECT p FROM GateInPermission p WHERE p.referenceType = :refType AND p.referenceId = :refId AND p.type = :type")})
public class PermissionEntity
implements Serializable {
    private static final long serialVersionUID = 1173817577220348267L;
    @Id
    @SequenceGenerator(name="SEQ_PORTAL_PERMISSIONS_ID", sequenceName="SEQ_PORTAL_PERMISSIONS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_PORTAL_PERMISSIONS_ID")
    @Column(name="PERMISSION_ID")
    private Long id;
    @Column(name="REF_TYPE", length=200)
    private String referenceType;
    @Column(name="REF_ID")
    private Long referenceId;
    @Column(name="PERMISSION", length=200)
    private String permission;
    @Column(name="TYPE")
    private TYPE type;

    public PermissionEntity() {
    }

    public PermissionEntity(String referenceType, long referenceId, String permission, TYPE type) {
        this.referenceType = referenceType;
        this.referenceId = referenceId;
        this.permission = permission;
        this.type = type;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.referenceType == null ? 0 : this.referenceType.hashCode());
        result = 31 * result + (this.referenceId == null ? 0 : this.referenceId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PermissionEntity other = (PermissionEntity)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.referenceType == null ? other.referenceType != null : !this.referenceType.equals(other.referenceType)) {
            return false;
        }
        if (this.referenceId == null ? other.referenceId != null : !this.referenceId.equals(other.referenceId)) {
            return false;
        }
        return !(this.permission == null ? other.permission != null : !this.permission.equals(other.permission));
    }

    public static enum TYPE {
        ACCESS,
        EDIT,
        MOVE_APP,
        MOVE_CONTAINER;

    }
}

