/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener;

import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosEntityType;
import io.meeds.kudos.service.KudosService;
import io.meeds.kudos.service.utils.Utils;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KudosSentActivityGeneratorListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(KudosSentActivityGeneratorListener.class);
    @Autowired
    private ActivityStorage activityStorage;
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("exo.kudos.sent", (ListenerBase)this);
    }

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        KudosService kudosService = (KudosService)event.getSource();
        if (kudosService.isActivityComment(kudos)) {
            String activityId = kudos.getEntityId();
            try {
                String parentCommentId = null;
                ExoSocialActivity activity = null;
                if (KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT) {
                    ExoSocialActivity comment = this.activityManager.getActivity(activityId);
                    if (comment != null) {
                        activity = this.activityManager.getParentActivity(comment);
                        parentCommentId = comment.getParentCommentId() != null ? comment.getParentCommentId() : comment.getId();
                    }
                } else {
                    activity = this.activityManager.getActivity(activityId);
                }
                if (activity == null) {
                    throw new IllegalStateException("Activity with id '" + activityId + "' wasn't found");
                }
                ExoSocialActivity activityComment = this.createActivity(kudos, parentCommentId);
                this.activityManager.saveComment(activity, activityComment);
                long commentId = Utils.getActivityId(activityComment.getId());
                kudos.setActivityId(commentId);
                kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId(), commentId);
                this.clearActivityCached(activity.getId());
                this.clearActivityCached(activityComment.getId());
            }
            catch (Exception e) {
                LOG.warn((Object)("Error adding comment on activity with id '" + activityId + "' for Kudos with id " + kudos.getTechnicalId()), (Throwable)e);
            }
        } else {
            Identity owner;
            ExoSocialActivity activity = this.createActivity(kudos, null);
            String providerId = "organization";
            String remoteId = kudos.getReceiverId();
            boolean isSpaceActivity = StringUtils.isNotBlank((CharSequence)kudos.getSpacePrettyName());
            if ("space".equals(kudos.getReceiverType()) || isSpaceActivity) {
                providerId = "space";
                if (isSpaceActivity) {
                    remoteId = kudos.getSpacePrettyName();
                }
            }
            if ((owner = this.identityManager.getOrCreateIdentity(providerId, remoteId)) == null) {
                LOG.warn("Can't find receiver identity with type/id", new Object[]{kudos.getReceiverType(), remoteId});
            } else {
                this.activityManager.saveActivityNoReturn(owner, activity);
                kudosService.updateKudosGeneratedActivityId(kudos.getTechnicalId(), Utils.getActivityId(activity.getId()));
                this.clearActivityCached(activity.getId());
            }
        }
    }

    private ExoSocialActivity createActivity(Kudos kudos, String parentCommentId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setParentCommentId(parentCommentId);
        activity.setType("exokudos:activity");
        activity.setTitle(kudos.getMessage());
        activity.setBody("Kudos to " + kudos.getReceiverFullName());
        activity.setUserId(kudos.getSenderIdentityId());
        Utils.computeKudosActivityProperties((ExoSocialActivity)activity, kudos);
        return activity;
    }

    private void clearActivityCached(String id) {
        ActivityStorage activityStorage = this.activityStorage;
        if (activityStorage instanceof CachedActivityStorage) {
            CachedActivityStorage cachedActivityStorage = (CachedActivityStorage)activityStorage;
            cachedActivityStorage.clearActivityCached(id);
        }
    }
}

