/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.uber.UberData;
import org.springframework.hateoas.mediatype.uber.UberError;
import org.springframework.lang.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
final class Uber {
    private final String version;
    private final List<UberData> data;
    private final UberError error;

    @JsonCreator
    Uber(@JsonProperty(value="version") String version, @JsonProperty(value="data") @Nullable List<UberData> data, @JsonProperty(value="error") @Nullable UberError error) {
        this.version = version;
        this.data = data;
        this.error = error;
    }

    Uber() {
        this("1.0", null, null);
    }

    Uber withVersion(String version) {
        return this.version == version ? this : new Uber(version, this.data, this.error);
    }

    Uber withData(List<UberData> data) {
        return this.data == data ? this : new Uber(this.version, data, this.error);
    }

    Uber withError(UberError error) {
        return this.error == error ? this : new Uber(this.version, this.data, error);
    }

    @JsonIgnore
    Links getLinks() {
        if (this.data == null) {
            return Links.NONE;
        }
        return this.data.stream().flatMap(uberData -> uberData.getLinks().stream()).collect(Links.collector());
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public List<UberData> getData() {
        return this.data;
    }

    @JsonProperty
    public UberError getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Uber)) {
            return false;
        }
        Uber uber = (Uber)o;
        return Objects.equals(this.version, uber.version) && Objects.equals(this.data, uber.data) && Objects.equals(this.error, uber.error);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.data, this.error);
    }
}

