/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.LinkedHashSet;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

final class OAuth2ImportSelector
implements ImportSelector {
    OAuth2ImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        boolean oauth2ClientPresent = ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ClientRegistration", (ClassLoader)classLoader);
        boolean webfluxPresent = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.ExchangeFilterFunction", (ClassLoader)classLoader);
        boolean oauth2ResourceServerPresent = ClassUtils.isPresent((String)"org.springframework.security.oauth2.server.resource.BearerTokenError", (ClassLoader)classLoader);
        if (oauth2ClientPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.OAuth2ClientConfiguration");
        }
        if (webfluxPresent && oauth2ClientPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration");
        }
        if (webfluxPresent && oauth2ResourceServerPresent) {
            imports.add("org.springframework.security.config.annotation.web.configuration.SecurityReactorContextConfiguration");
        }
        return StringUtils.toStringArray(imports);
    }
}

