/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.utils;

import io.meeds.tenant.hub.service.PolygonContractGasProvider;
import io.meeds.wom.api.constant.WomException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.JsonRpcError;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.TransactionReceiptProcessor;

public class ContractUtils {
    public static final Event REPORTSENT_EVENT = new Event("ReportSent", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}));

    private ContractUtils() {
    }

    public static RemoteFunctionCall<TransactionReceipt> executeRemoteCallTransaction(TransactionManager transactionManager, PolygonContractGasProvider polygonContractGasProvider, TransactionReceiptProcessor transactionReceiptProcessor, Function function, String uemAddress, long uemNetworkId) {
        return new RemoteFunctionCall(function, () -> ContractUtils.executeTransaction(transactionManager, polygonContractGasProvider, transactionReceiptProcessor, FunctionEncoder.encode((Function)function), function.getName(), uemAddress, uemNetworkId));
    }

    private static TransactionReceipt executeTransaction(TransactionManager transactionManager, PolygonContractGasProvider polygonContractGasProvider, TransactionReceiptProcessor transactionReceiptProcessor, String data, String funcName, String uemAddress, long uemNetworkId) {
        try {
            String fromAddress = transactionManager.getFromAddress();
            BigInteger gasPrice = polygonContractGasProvider.getGasPrice(funcName);
            BigInteger gasLimit = polygonContractGasProvider.getGasLimit(funcName);
            BigInteger nonce = ContractUtils.getNonce(polygonContractGasProvider.getWeb3j(), fromAddress);
            Transaction tx = Transaction.createFunctionCallTransaction((String)fromAddress, (BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)uemAddress, (String)data);
            EthEstimateGas gasEstimate = (EthEstimateGas)polygonContractGasProvider.getWeb3j().ethEstimateGas(tx).send();
            if (gasEstimate.hasError()) {
                throw new WomException(gasEstimate.getError().getMessage());
            }
            BigInteger estimatedGas = gasEstimate.getAmountUsed();
            EthSendTransaction sendTransactionCall = transactionManager.sendTransaction(gasPrice, BigDecimal.valueOf(estimatedGas.doubleValue()).multiply(BigDecimal.valueOf(1.2)).toBigInteger(), uemAddress, data, BigInteger.ZERO);
            return ContractUtils.processResponse(transactionReceiptProcessor, sendTransactionCall);
        }
        catch (JsonRpcError error) {
            if (error.getData() != null) {
                throw new TransactionException(error.getData().toString());
            }
            throw new TransactionException(String.format("JsonRpcError thrown with code %d. Message: %s", error.getCode(), error.getMessage()));
        }
    }

    private static BigInteger getNonce(Web3j web3j, String address) {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)web3j.ethGetTransactionCount(address, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    private static TransactionReceipt processResponse(TransactionReceiptProcessor transactionReceiptProcessor, EthSendTransaction ethSendTransaction) throws IOException, TransactionException {
        if (ethSendTransaction.hasError()) {
            throw new JsonRpcError(ethSendTransaction.getError());
        }
        String transactionHash = ethSendTransaction.getTransactionHash();
        return transactionReceiptProcessor.waitForTransactionReceipt(transactionHash);
    }

    public static List<ReportSentEventResponse> getReportSentEvents(TransactionReceipt transactionReceipt) {
        List<EventValuesWithLog> valueList = ContractUtils.staticExtractEventParametersWithLog(REPORTSENT_EVENT, transactionReceipt);
        ArrayList<ReportSentEventResponse> responses = new ArrayList<ReportSentEventResponse>(valueList.size());
        for (EventValuesWithLog eventValues : valueList) {
            ReportSentEventResponse typedResponse = new ReportSentEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.hub = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.reportId = (BigInteger)eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    private static List<EventValuesWithLog> staticExtractEventParametersWithLog(Event event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> ContractUtils.staticExtractEventParametersWithLog(event, log)).filter(Objects::nonNull).toList();
    }

    private static EventValuesWithLog staticExtractEventParametersWithLog(Event event, Log log) {
        EventValues eventValues = Contract.staticExtractEventParameters((Event)event, (Log)log);
        return eventValues == null ? null : new EventValuesWithLog(eventValues, log);
    }

    public static class EventValuesWithLog {
        private final EventValues eventValues;
        private final Log log;

        public EventValuesWithLog(EventValues eventValues, Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<Type> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<Type> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public Log getLog() {
            return this.log;
        }
    }

    public static class ReportSentEventResponse
    extends BaseEventResponse {
        public String hub;
        public BigInteger reportId;
    }
}

