/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.DfsKnnProfile;
import co.elastic.clients.elasticsearch.core.search.DfsStatisticsProfile;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DfsProfile
implements JsonpSerializable {
    @Nullable
    private final DfsStatisticsProfile statistics;
    private final List<DfsKnnProfile> knn;
    public static final JsonpDeserializer<DfsProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DfsProfile::setupDfsProfileDeserializer);

    private DfsProfile(Builder builder) {
        this.statistics = builder.statistics;
        this.knn = ApiTypeHelper.unmodifiable(builder.knn);
    }

    public static DfsProfile of(Function<Builder, ObjectBuilder<DfsProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DfsStatisticsProfile statistics() {
        return this.statistics;
    }

    public final List<DfsKnnProfile> knn() {
        return this.knn;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.statistics != null) {
            generator.writeKey("statistics");
            this.statistics.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.knn)) {
            generator.writeKey("knn");
            generator.writeStartArray();
            for (DfsKnnProfile item0 : this.knn) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDfsProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::statistics, DfsStatisticsProfile._DESERIALIZER, "statistics");
        op.add(Builder::knn, JsonpDeserializer.arrayDeserializer(DfsKnnProfile._DESERIALIZER), "knn");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DfsProfile> {
        @Nullable
        private DfsStatisticsProfile statistics;
        @Nullable
        private List<DfsKnnProfile> knn;

        public final Builder statistics(@Nullable DfsStatisticsProfile value) {
            this.statistics = value;
            return this;
        }

        public final Builder statistics(Function<DfsStatisticsProfile.Builder, ObjectBuilder<DfsStatisticsProfile>> fn) {
            return this.statistics(fn.apply(new DfsStatisticsProfile.Builder()).build());
        }

        public final Builder knn(List<DfsKnnProfile> list) {
            this.knn = Builder._listAddAll(this.knn, list);
            return this;
        }

        public final Builder knn(DfsKnnProfile value, DfsKnnProfile ... values) {
            this.knn = Builder._listAdd(this.knn, value, values);
            return this;
        }

        public final Builder knn(Function<DfsKnnProfile.Builder, ObjectBuilder<DfsKnnProfile>> fn) {
            return this.knn(fn.apply(new DfsKnnProfile.Builder()).build(), new DfsKnnProfile[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DfsProfile build() {
            this._checkSingleUse();
            return new DfsProfile(this);
        }
    }
}

