/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class OpenJobResponse
implements JsonpSerializable {
    private final boolean opened;
    private final String node;
    public static final JsonpDeserializer<OpenJobResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenJobResponse::setupOpenJobResponseDeserializer);

    private OpenJobResponse(Builder builder) {
        this.opened = ApiTypeHelper.requireNonNull(builder.opened, (Object)this, "opened", false);
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
    }

    public static OpenJobResponse of(Function<Builder, ObjectBuilder<OpenJobResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean opened() {
        return this.opened;
    }

    public final String node() {
        return this.node;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("opened");
        generator.write(this.opened);
        generator.writeKey("node");
        generator.write(this.node);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupOpenJobResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::opened, JsonpDeserializer.booleanDeserializer(), "opened");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OpenJobResponse> {
        private Boolean opened;
        private String node;

        public final Builder opened(boolean value) {
            this.opened = value;
            return this;
        }

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenJobResponse build() {
            this._checkSingleUse();
            return new OpenJobResponse(this);
        }
    }
}

