/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.gatein.common.i18n.BundleName;
import org.gatein.common.i18n.ResourceBundleFactory;
import org.gatein.common.io.IOTools;

public class ComplexResourceBundleFactory
implements ResourceBundleFactory {
    private final ClassLoader resourceLoader;
    private final String baseName;

    public ComplexResourceBundleFactory(ClassLoader resourceLoader, String baseName) {
        this.resourceLoader = resourceLoader;
        this.baseName = baseName;
    }

    @Override
    public ResourceBundle getBundle(Locale locale) throws IllegalArgumentException {
        ResourceBundle bundle;
        BundleName name;
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        BundleName.Iterator iterator = new BundleName.Iterator(this.baseName, locale);
        while (iterator.hasNext()) {
            name = iterator.next();
            if (!iterator.hasNext()) break;
            bundle = this.lookup(name.toString());
            if (bundle == null) continue;
            return bundle;
        }
        iterator = new BundleName.Iterator(this.baseName, Locale.getDefault());
        while (iterator.hasNext()) {
            name = iterator.next();
            bundle = this.lookup(name.toString());
            if (bundle == null) continue;
            return bundle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle lookup(String s) {
        String propertyName = s.replace('.', '/') + ".properties";
        InputStream in = this.resourceLoader.getResourceAsStream(propertyName);
        if (in != null) {
            try {
                in = IOTools.safeBufferedWrapper(in);
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(in);
                return propertyResourceBundle;
            }
            catch (IOException e) {
            }
            finally {
                IOTools.safeClose(in);
            }
        }
        return null;
    }
}

