/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

public abstract class IdentityProvider<T> {
    public Identity getIdentityByRemoteId(String remoteId) {
        T target = this.findByRemoteId(remoteId);
        if (target == null) {
            return null;
        }
        Identity identity = this.createIdentity(target);
        Profile profile = new Profile(identity);
        this.populateProfile(profile, target);
        identity.setProfile(profile);
        return identity;
    }

    public abstract String getName();

    public abstract T findByRemoteId(String var1);

    public abstract Identity createIdentity(T var1);

    public abstract void populateProfile(Profile var1, T var2);

    public void onSaveIdentity(Identity identity) {
    }

    @Deprecated
    public void onSaveProfile(Profile profile) {
    }

    public void onUpdateProfile(Profile profile) {
    }

    @Deprecated
    public List<String> getAllUserId() {
        throw new RuntimeException("getAllUserId() is not implemented for " + String.valueOf(this.getClass()));
    }
}

