/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.QueryVectorBuilder;
import co.elastic.clients.elasticsearch._types.QueryVectorBuilderVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextEmbedding
implements QueryVectorBuilderVariant,
JsonpSerializable {
    @Nullable
    private final String modelId;
    private final String modelText;
    public static final JsonpDeserializer<TextEmbedding> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextEmbedding::setupTextEmbeddingDeserializer);

    private TextEmbedding(Builder builder) {
        this.modelId = builder.modelId;
        this.modelText = ApiTypeHelper.requireNonNull(builder.modelText, this, "modelText");
    }

    public static TextEmbedding of(Function<Builder, ObjectBuilder<TextEmbedding>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public QueryVectorBuilder.Kind _queryVectorBuilderKind() {
        return QueryVectorBuilder.Kind.TextEmbedding;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    public final String modelText() {
        return this.modelText;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        generator.writeKey("model_text");
        generator.write(this.modelText);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextEmbeddingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::modelText, JsonpDeserializer.stringDeserializer(), "model_text");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextEmbedding> {
        @Nullable
        private String modelId;
        private String modelText;

        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public final Builder modelText(String value) {
            this.modelText = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextEmbedding build() {
            this._checkSingleUse();
            return new TextEmbedding(this);
        }
    }
}

