/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.elasticsearch.indices.stats.ShardRoutingState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardRouting
implements JsonpSerializable {
    private final String node;
    private final boolean primary;
    @Nullable
    private final String relocatingNode;
    private final ShardRoutingState state;
    public static final JsonpDeserializer<ShardRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRouting::setupShardRoutingDeserializer);

    private ShardRouting(Builder builder) {
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.primary = ApiTypeHelper.requireNonNull(builder.primary, (Object)this, "primary", false);
        this.relocatingNode = builder.relocatingNode;
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static ShardRouting of(Function<Builder, ObjectBuilder<ShardRouting>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String node() {
        return this.node;
    }

    public final boolean primary() {
        return this.primary;
    }

    @Nullable
    public final String relocatingNode() {
        return this.relocatingNode;
    }

    public final ShardRoutingState state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.relocatingNode != null) {
            generator.writeKey("relocating_node");
            generator.write(this.relocatingNode);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardRoutingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::relocatingNode, JsonpDeserializer.stringDeserializer(), "relocating_node");
        op.add(Builder::state, ShardRoutingState._DESERIALIZER, "state");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardRouting> {
        private String node;
        private Boolean primary;
        @Nullable
        private String relocatingNode;
        private ShardRoutingState state;

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public final Builder relocatingNode(@Nullable String value) {
            this.relocatingNode = value;
            return this;
        }

        public final Builder state(ShardRoutingState value) {
            this.state = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardRouting build() {
            this._checkSingleUse();
            return new ShardRouting(this);
        }
    }
}

