/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.plugin;

import io.meeds.github.gamification.model.Event;
import io.meeds.github.gamification.plugin.GithubTriggerPlugin;
import io.meeds.github.gamification.services.GithubTriggerService;
import io.meeds.github.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentTriggerPlugin
extends GithubTriggerPlugin {
    private static final String NAME = "issue_comment";
    @Autowired
    private GithubTriggerService githubTriggerService;

    @PostConstruct
    public void init() {
        this.githubTriggerService.addPlugin(this);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String eventType;
        String pullRequest = Utils.extractSubItem(payload, "issue", "pull_request");
        String action = Utils.extractSubItem(payload, "action");
        String comment = Utils.extractSubItem(payload, "comment", "html_url");
        String userId = Utils.extractSubItem(payload, "sender", "login");
        String string = eventType = StringUtils.isBlank((CharSequence)pullRequest) ? "githubCommentIssue" : "githubCommentPR";
        if (action != null) {
            String eventName;
            switch (action) {
                case "created": {
                    eventName = StringUtils.isBlank((CharSequence)pullRequest) ? "commentIssue" : "commentPullRequest";
                    break;
                }
                case "deleted": {
                    eventName = StringUtils.isBlank((CharSequence)pullRequest) ? "deleteIssueComment" : "deletePullRequestComment";
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            return Collections.singletonList(new Event(eventName, null, userId, comment, eventType, Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        return Collections.emptyList();
    }
}

