/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;

public class SpaceWebChannel
extends AbstractChannel {
    private static final Log LOG = ExoLogger.getLogger(SpaceWebChannel.class);
    public static final String ID = "SPACE_WEB_CHANNEL";
    public final ChannelKey key = ChannelKey.key((String)"SPACE_WEB_CHANNEL");
    private SpaceWebNotificationService spaceWebNotificationService;

    public SpaceWebChannel(SpaceWebNotificationService spaceWebNotificationService) {
        this.spaceWebNotificationService = spaceWebNotificationService;
    }

    public String getId() {
        return ID;
    }

    public ChannelKey getKey() {
        return this.key;
    }

    public void dispatch(NotificationContext ctx, String username) {
        NotificationInfo notification = ctx.getNotificationInfo();
        try {
            this.spaceWebNotificationService.dispatch(notification, username);
        }
        catch (Exception e) {
            LOG.warn("Error processing notification {}", new Object[]{notification, e});
        }
    }

    public void registerTemplateProvider(TemplateProvider provider) {
    }

    public boolean isDefaultChannel() {
        return false;
    }

    protected AbstractTemplateBuilder getTemplateBuilderInChannel(PluginKey key) {
        return null;
    }
}

