/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.search.listener;

import io.meeds.social.space.plugin.SpaceCategoryLifeCycleEvent;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class SpaceIndexingListenerImpl
extends SpaceListenerPlugin {
    public static final String METADATA_OBJECT_TYPE = "space";
    private static final Log LOG = ExoLogger.getExoLogger(SpaceIndexingListenerImpl.class);

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        this.updateSpaceTags(space);
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = space.getId();
        LOG.info("Notifying indexing service for space creation id={}", new Object[]{id});
        indexingService.index(METADATA_OBJECT_TYPE, id);
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space description");
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getSpace().getId();
        LOG.debug("Notifying indexing service for space removal id={}", new Object[]{id});
        indexingService.unindex(METADATA_OBJECT_TYPE, id);
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        this.reindex(event, "space renaming");
    }

    public void spaceSovereigntyEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space sovereignty edited");
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space access edited");
    }

    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space registration edited");
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member granted as manager");
    }

    public void joined(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member joined");
    }

    public void left(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member left");
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        this.reindex(event, "space member revoked as manager");
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space avatar updated");
    }

    public void addRedactorUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "add redactor");
    }

    public void removeRedactorUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "remove redactor");
    }

    public void addPublisherUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "add publisher");
    }

    public void removePublisherUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "remove publisher");
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "user invited to space");
    }

    public void removeInvitedUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "user invitation to space canceled");
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "user requested access to space");
    }

    public void removePendingUser(SpaceLifeCycleEvent event) {
        this.reindex(event, "user canceled request access to space");
    }

    public void categoryAdded(SpaceCategoryLifeCycleEvent event) {
        this.reindex((SpaceLifeCycleEvent)event, "space category added");
    }

    public void categoryRemoved(SpaceCategoryLifeCycleEvent event) {
        this.reindex((SpaceLifeCycleEvent)event, "space category removed");
    }

    private void reindex(SpaceLifeCycleEvent event, String cause) {
        Space space = event.getSpace();
        this.updateSpaceTags(space);
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = space.getId();
        LOG.debug("Notifying indexing service for {} id={}", new Object[]{cause, id});
        indexingService.reindex(METADATA_OBJECT_TYPE, id);
    }

    private void updateSpaceTags(Space space) {
        TagService tagService = (TagService)ExoContainerContext.getService(TagService.class);
        Set tagNames = tagService.detectTagNames(space.getDescription());
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        Identity spaceIdentity = identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        String editor = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{space.getEditor(), space.getManagers() == null || space.getManagers().length == 0 ? null : space.getManagers()[0]});
        if (editor == null) {
            LOG.warn((Object)"Can't update Space Tags due to missing editor username");
        } else {
            Identity creatorIdentity = identityManager.getOrCreateUserIdentity(editor);
            tagService.saveTags(new TagObject(METADATA_OBJECT_TYPE, space.getId()), tagNames, Long.parseLong(spaceIdentity.getId()), Long.parseLong(creatorIdentity.getId()));
        }
    }
}

