/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.model;

import io.meeds.wallet.model.RewardPeriodType;
import io.meeds.wallet.model.RewardSettings;
import io.meeds.wallet.model.RewardStatus;
import io.meeds.wallet.utils.RewardUtils;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import lombok.Generated;

public class RewardPeriod
implements Serializable {
    private static final long serialVersionUID = -4860665131754056537L;
    private long id;
    private RewardPeriodType rewardPeriodType;
    private String timeZone = ZoneId.systemDefault().getId();
    private long startDateInSeconds;
    private long endDateInSeconds;
    private RewardStatus status;

    public RewardPeriod(RewardPeriodType rewardPeriodType) {
        this.rewardPeriodType = rewardPeriodType;
    }

    public RewardPeriod(RewardPeriodType rewardPeriodType, String timeZone, long startDateInSeconds, long endDateInSeconds) {
        this.rewardPeriodType = rewardPeriodType;
        this.timeZone = timeZone;
        this.startDateInSeconds = startDateInSeconds;
        this.endDateInSeconds = endDateInSeconds;
    }

    public static RewardPeriod getCurrentPeriod(RewardSettings rewardSettings) {
        ZoneId zoneId = rewardSettings == null ? ZoneId.systemDefault() : rewardSettings.zoneId();
        return RewardPeriod.getPeriodOfTime(rewardSettings, LocalDate.now(zoneId));
    }

    public static RewardPeriod getPeriodOfTime(RewardSettings rewardSettings, LocalDate date) {
        ZoneId zoneId = rewardSettings == null ? ZoneId.systemDefault() : rewardSettings.zoneId();
        RewardPeriodType rewardPeriodType = rewardSettings == null || rewardSettings.getPeriodType() == null ? RewardPeriodType.DEFAULT : rewardSettings.getPeriodType();
        return rewardPeriodType.getPeriodOfTime(date, zoneId);
    }

    public ZoneId zoneId() {
        return ZoneId.of(this.timeZone);
    }

    public LocalDate getPeriodMedianDate() {
        return LocalDate.ofInstant(Instant.ofEpochSecond(this.getPeriodMedianDateInSeconds()), this.zoneId());
    }

    public long getPeriodMedianDateInSeconds() {
        return (this.endDateInSeconds + this.startDateInSeconds) / 2L;
    }

    public String getStartDateFormatted(String lang) {
        return RewardUtils.formatTime(this.startDateInSeconds, this.zoneId(), lang);
    }

    public String getEndDateFormatted(String lang) {
        return RewardUtils.formatTime(this.endDateInSeconds, this.zoneId(), lang);
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public RewardPeriodType getRewardPeriodType() {
        return this.rewardPeriodType;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public long getStartDateInSeconds() {
        return this.startDateInSeconds;
    }

    @Generated
    public long getEndDateInSeconds() {
        return this.endDateInSeconds;
    }

    @Generated
    public RewardStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setRewardPeriodType(RewardPeriodType rewardPeriodType) {
        this.rewardPeriodType = rewardPeriodType;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public void setStartDateInSeconds(long startDateInSeconds) {
        this.startDateInSeconds = startDateInSeconds;
    }

    @Generated
    public void setEndDateInSeconds(long endDateInSeconds) {
        this.endDateInSeconds = endDateInSeconds;
    }

    @Generated
    public void setStatus(RewardStatus status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardPeriod)) {
            return false;
        }
        RewardPeriod other = (RewardPeriod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartDateInSeconds() != other.getStartDateInSeconds()) {
            return false;
        }
        if (this.getEndDateInSeconds() != other.getEndDateInSeconds()) {
            return false;
        }
        RewardPeriodType this$rewardPeriodType = this.getRewardPeriodType();
        RewardPeriodType other$rewardPeriodType = other.getRewardPeriodType();
        if (this$rewardPeriodType == null ? other$rewardPeriodType != null : !((Object)((Object)this$rewardPeriodType)).equals((Object)other$rewardPeriodType)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        RewardStatus this$status = this.getStatus();
        RewardStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RewardPeriod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startDateInSeconds = this.getStartDateInSeconds();
        result = result * 59 + (int)($startDateInSeconds >>> 32 ^ $startDateInSeconds);
        long $endDateInSeconds = this.getEndDateInSeconds();
        result = result * 59 + (int)($endDateInSeconds >>> 32 ^ $endDateInSeconds);
        RewardPeriodType $rewardPeriodType = this.getRewardPeriodType();
        result = result * 59 + ($rewardPeriodType == null ? 43 : ((Object)((Object)$rewardPeriodType)).hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        RewardStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RewardPeriod(id=" + this.getId() + ", rewardPeriodType=" + String.valueOf((Object)this.getRewardPeriodType()) + ", timeZone=" + this.getTimeZone() + ", startDateInSeconds=" + this.getStartDateInSeconds() + ", endDateInSeconds=" + this.getEndDateInSeconds() + ", status=" + String.valueOf((Object)this.getStatus()) + ")";
    }

    @Generated
    public RewardPeriod() {
    }
}

