/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCommentAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "taskComment";
    @Autowired
    private TaskService taskService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        CommentDto comment = this.commentService.getComment(Long.parseLong(objectId));
        TaskDto task = comment.getTask();
        if (task == null) {
            return false;
        }
        return switch (permissionType) {
            case "VIEW" -> TaskUtil.hasViewPermission(this.taskService, task, identity);
            case "EDIT" -> TaskUtil.hasEditPermission(this.taskService, task, identity);
            case "DELETE" -> TaskUtil.hasDeletePermission(task, identity);
            default -> false;
        };
    }
}

