/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.entity;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.LinkEntity;

public class SpaceEntity
extends BaseEntity {
    private static final long serialVersionUID = -5407676622915680099L;

    public SpaceEntity() {
    }

    public SpaceEntity(String id) {
        super(id);
    }

    public SpaceEntity setIdentity(LinkEntity identity) {
        this.setProperty("identity", identity.getData());
        return this;
    }

    public SpaceEntity setIdentityId(String identityId) {
        this.setProperty("identityId", identityId);
        return this;
    }

    public SpaceEntity setDisplayName(String displayName) {
        this.setProperty("displayName", displayName);
        return this;
    }

    public String getDisplayName() {
        return this.getString("displayName");
    }

    public SpaceEntity setTemplateId(Long templateId) {
        this.setProperty("templateId", templateId == null ? "0" : templateId.toString());
        return this;
    }

    public long getTemplateId() {
        String templateId = this.getString("templateId");
        return StringUtils.isBlank((CharSequence)templateId) ? 0L : Long.parseLong(templateId);
    }

    public SpaceEntity setCategoryIds(List<Long> categoryIds) {
        this.setProperty("categoryIds", CollectionUtils.isNotEmpty(categoryIds) ? categoryIds : null);
        return this;
    }

    public List<Long> getCategoryIds() {
        return (List)this.getProperty("categoryIds");
    }

    public SpaceEntity setSovereign(boolean sovereign) {
        this.setProperty("sovereign", sovereign);
        return this;
    }

    public Boolean getSovereign() {
        Object sovereign = this.getProperty("sovereign");
        return sovereign == null ? null : Boolean.valueOf((Boolean)sovereign);
    }

    public SpaceEntity setUrl(String url) {
        this.setProperty("url", url);
        return this;
    }

    public String getUrl() {
        return this.getString("url");
    }

    public SpaceEntity setGroupId(String groupId) {
        this.setProperty("groupId", groupId);
        return this;
    }

    public String getGroupId() {
        return this.getString("groupId");
    }

    public SpaceEntity setBannerId(String bannerId) {
        this.setProperty("bannerId", bannerId);
        return this;
    }

    public String getBannerId() {
        return this.getString("bannerId");
    }

    public SpaceEntity setAvatarId(String avatarId) {
        this.setProperty("avatarId", avatarId);
        return this;
    }

    public String getAvatarId() {
        return this.getString("avatarId");
    }

    public SpaceEntity setPrettyName(String prettyName) {
        this.setProperty("prettyName", prettyName);
        return this;
    }

    public String getPrettyName() {
        return this.getString("prettyName");
    }

    public SpaceEntity setPublicSiteId(Long publicSiteId) {
        this.setProperty("publicSiteId", publicSiteId);
        return this;
    }

    public Long getPublicSiteId() {
        return (Long)this.getProperty("publicSiteId");
    }

    public SpaceEntity setPublicSiteName(String publicSiteName) {
        this.setProperty("publicSiteName", publicSiteName);
        return this;
    }

    public String getPublicSiteName() {
        return (String)this.getProperty("publicSiteName");
    }

    public SpaceEntity setPublicSiteVisibility(String publicSiteVisibility) {
        this.setProperty("publicSiteVisibility", publicSiteVisibility);
        return this;
    }

    public String getPublicSiteVisibility() {
        return this.getString("publicSiteVisibility");
    }

    public SpaceEntity setHasBindings(boolean hasBindings) {
        this.setProperty("hasBindings", hasBindings);
        return this;
    }

    public SpaceEntity setTotalBoundUsers(Long totalBoundUsers) {
        this.setProperty("totalBoundUsers", totalBoundUsers);
        return this;
    }

    public Long getTotalBoundUsers() {
        return (Long)this.getProperty("totalBoundUsers");
    }

    public String hasBindings() {
        return this.getString("hasBindings");
    }

    public SpaceEntity setAvatarUrl(String avatarUrl) {
        this.setProperty("avatarUrl", avatarUrl);
        return this;
    }

    public String getAvatarUrl() {
        return this.getString("avatarUrl");
    }

    public SpaceEntity setBannerUrl(String bannerUrl) {
        this.setProperty("bannerUrl", bannerUrl);
        return this;
    }

    public String getBannerUrl() {
        return this.getString("bannerUrl");
    }

    public SpaceEntity setVisibility(String visibility) {
        this.setProperty("visibility", visibility);
        return this;
    }

    public String getVisibility() {
        return this.getString("visibility");
    }

    public SpaceEntity setSubscription(String subscription) {
        this.setProperty("subscription", subscription);
        return this;
    }

    public String getSubscription() {
        return this.getString("subscription");
    }

    public SpaceEntity setDescription(String description) {
        this.setProperty("description", description);
        return this;
    }

    public String getDescription() {
        return this.getString("description");
    }

    public SpaceEntity setIsManager(boolean isManager) {
        this.setProperty("isManager", isManager);
        return this;
    }

    public Boolean getIsManager() {
        return (Boolean)this.getProperty("isManager");
    }

    public SpaceEntity setIsRedactor(boolean isRedactor) {
        this.setProperty("isRedactor", isRedactor);
        return this;
    }

    public Boolean getIsRedactor() {
        return (Boolean)this.getProperty("isRedactor");
    }

    public SpaceEntity setIsPublisher(boolean isPublisher) {
        this.setProperty("isPublisher", isPublisher);
        return this;
    }

    public Boolean getIsPublisher() {
        return (Boolean)this.getProperty("isPublisher");
    }

    public SpaceEntity setCreatedTime(String creationTime) {
        this.setProperty("createdTime", creationTime);
        return this;
    }

    public String getCreatedTime() {
        return (String)this.getProperty("createdTime");
    }

    public SpaceEntity setCanEdit(boolean canEdit) {
        this.setProperty("canEdit", canEdit);
        return this;
    }

    public Boolean getCanEdit() {
        return (Boolean)this.getProperty("canEdit");
    }

    public SpaceEntity setCanDelete(boolean canDelete) {
        this.setProperty("canDelete", canDelete);
        return this;
    }

    public Boolean getCanDelete() {
        return (Boolean)this.getProperty("canDelete");
    }

    public SpaceEntity setCanManagePublicSite(boolean canDelete) {
        this.setProperty("canManagePublicSite", canDelete);
        return this;
    }

    public Boolean getCanManagePublicSite() {
        return (Boolean)this.getProperty("canManagePublicSite");
    }

    public SpaceEntity setCanRedactOnSpace(boolean canRedactOnSpace) {
        this.setProperty("canRedactOnSpace", canRedactOnSpace);
        return this;
    }

    public Boolean getCanRedactOnSpace() {
        return (Boolean)this.getProperty("canRedactOnSpace");
    }

    public SpaceEntity setCanEditNavigations(boolean canEditNavigations) {
        this.setProperty("canEditNavigations", canEditNavigations);
        return this;
    }

    public Boolean getCanEditNavigations() {
        return (Boolean)this.getProperty("canEditNavigations");
    }

    public SpaceEntity setSiteId(String siteId) {
        this.setProperty("siteId", siteId);
        return this;
    }

    public String getSiteId() {
        return (String)this.getProperty("siteId");
    }

    public SpaceEntity setManagers(LinkEntity managers) {
        this.setProperty("managers", managers.getData());
        return this;
    }

    public String getManagers() {
        return this.getString("managers");
    }

    public SpaceEntity setManagersCount(int managersCount) {
        this.setProperty("managersCount", managersCount);
        return this;
    }

    public Integer getManagersCount() {
        return (Integer)this.getProperty("managersCount");
    }

    public SpaceEntity setRedactors(LinkEntity redactors) {
        this.setProperty("redactors", redactors.getData());
        return this;
    }

    public String getRedactors() {
        return this.getString("redactors");
    }

    public SpaceEntity setRedactorsCount(int redactorsCount) {
        this.setProperty("redactorsCount", redactorsCount);
        return this;
    }

    public Integer getRedactorsCount() {
        return (Integer)this.getProperty("redactorsCount");
    }

    public SpaceEntity setPublishers(LinkEntity publishers) {
        this.setProperty("publishers", publishers.getData());
        return this;
    }

    public String getPublishers() {
        return this.getString("publishers");
    }

    public SpaceEntity setPublishersCount(int publishersCount) {
        this.setProperty("publishersCount", publishersCount);
        return this;
    }

    public Integer getPublishersCount() {
        return (Integer)this.getProperty("publishersCount");
    }

    public SpaceEntity setPendingUsersCount(int pendingUsersCount) {
        this.setProperty("pendingUsersCount", pendingUsersCount);
        return this;
    }

    public Integer getPendingUsersCount() {
        return (Integer)this.getProperty("pendingUsersCount");
    }

    public SpaceEntity setInvitedUsersCount(int invitedUsersCount) {
        this.setProperty("invitedUsersCount", invitedUsersCount);
        return this;
    }

    public Integer getInvitedUsersCountCount() {
        return (Integer)this.getProperty("invitedUsersCount");
    }

    public SpaceEntity setIsMember(boolean isMember) {
        this.setProperty("isMember", isMember);
        return this;
    }

    public Boolean getIsMember() {
        return (Boolean)this.getProperty("isMember");
    }

    public SpaceEntity setMembers(LinkEntity members) {
        this.setProperty("members", members.getData());
        return this;
    }

    public String getMembers() {
        return this.getString("members");
    }

    public SpaceEntity setPending(LinkEntity pending) {
        this.setProperty("pending", pending.getData());
        return this;
    }

    public String getPending() {
        return this.getString("pending");
    }

    public SpaceEntity setMembersCount(int membersCount) {
        this.setProperty("membersCount", membersCount);
        return this;
    }

    public Integer getMembersCount() {
        return (Integer)this.getProperty("membersCount");
    }

    public SpaceEntity setIsPending(boolean isPending) {
        this.setProperty("isPending", isPending);
        return this;
    }

    public SpaceEntity setIsUserBound(boolean isUserBound) {
        this.setProperty("isUserBound", isUserBound);
        return this;
    }

    public Boolean getIsUserBound() {
        return (Boolean)this.getProperty("isUserBound");
    }

    public Boolean getIsPending() {
        return (Boolean)this.getProperty("isPending");
    }

    public SpaceEntity setIsInvited(boolean isInvited) {
        this.setProperty("isInvited", isInvited);
        return this;
    }

    public Boolean getIsInvited() {
        return (Boolean)this.getProperty("isInvited");
    }

    public SpaceEntity setInvitedMembers(List<Identity> invitedIdentities) {
        this.setProperty("invitedMembers", invitedIdentities);
        return this;
    }

    public List<Identity> getInvitedMembers() {
        return (List)this.getProperty("invitedMembers");
    }

    public SpaceEntity setExternalInvitedUsers(List<String> externalInvitedUsers) {
        this.setProperty("externalInvitedUsers", externalInvitedUsers);
        return this;
    }

    public List<String> getExternalInvitedUsers() {
        return (List)this.getProperty("externalInvitedUsers");
    }

    public String getIsFavorite() {
        return this.getString("isFavorite");
    }

    public SpaceEntity setIsFavorite(String isFavorite) {
        this.setProperty("isFavorite", isFavorite);
        return this;
    }

    public String getIsMuted() {
        return this.getString("isMuted");
    }

    public SpaceEntity setIsMuted(String isMuted) {
        this.setProperty("isMuted", isMuted);
        return this;
    }

    public Map<String, Long> getUnreadItems() {
        return (Map)this.getProperty("unread");
    }

    public SpaceEntity setUnreadItems(Map<String, Long> getUnreadItems) {
        this.setProperty("unread", getUnreadItems);
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceEntity)) {
            return false;
        }
        SpaceEntity other = (SpaceEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpaceEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

