/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.store.hibernate;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gatein.portal.idm.IdentityStoreSource;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.picketlink.idm.impl.store.hibernate.PatchedHibernateIdentityStoreImpl;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

public class ExoHibernateIdentityStoreImpl
extends PatchedHibernateIdentityStoreImpl
implements IdentityStore,
IdentityStoreSource,
Serializable {
    private static Logger log = Logger.getLogger(ExoHibernateIdentityStoreImpl.class.getName());
    public static final String DEFAULT_REALM_NAME = ExoHibernateIdentityStoreImpl.class.getName() + ".DEFAULT_REALM";
    private boolean isRealmAware = false;

    public ExoHibernateIdentityStoreImpl(String id) {
        super(id);
    }

    private String getRealmName(IdentityStoreInvocationContext ctx) {
        if (this.isRealmAware()) {
            return ctx.getRealmId();
        }
        return DEFAULT_REALM_NAME;
    }

    private boolean isRealmAware() {
        return this.isRealmAware;
    }

    private void checkIOInstance(IdentityObject io) {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
    }

    private HibernateIdentityObjectCredentialType getHibernateIdentityObjectCredentialType(IdentityStoreInvocationContext ctx, IdentityObjectCredentialType credentialType) throws IdentityException {
        Session session = this.getHibernateSession(ctx);
        HibernateIdentityObjectCredentialType hibernateType = null;
        try {
            hibernateType = (HibernateIdentityObjectCredentialType)session.createQuery("SELECT ct FROM HibernateIdentityObjectCredentialType ct WHERE ct.name = :name").setParameter("name", (Object)credentialType.getName()).uniqueResult();
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectCredentialType[ " + credentialType.getName() + "] not present in the store.");
        }
        return hibernateType;
    }

    private HibernateIdentityObject safeGet(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        this.checkIOInstance(io);
        if (io instanceof HibernateIdentityObject) {
            return (HibernateIdentityObject)io;
        }
        return this.getHibernateIdentityObject(ctx, io);
    }

    private HibernateIdentityObject getHibernateIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            return (HibernateIdentityObject)hibernateSession.createNamedQuery("HibernateIdentityObject.findIdentityObjectByNameAndType", HibernateIdentityObject.class).setParameter("name", (Object)io.getName().toLowerCase()).setParameter("typeName", (Object)io.getIdentityType().getName()).setParameter("realmName", (Object)this.getRealmName(ctx)).uniqueResult();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObject[ " + io.getName() + " | " + io.getIdentityType().getName() + "] not present in the store.", (Throwable)e);
        }
    }

    @Override
    public boolean isFirstlyCreatedIn(IdentityStoreInvocationContext ctx, IdentityObject identityObject) throws Exception {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        if (hibernateObject != null && this.getSupportedFeatures().isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), (IdentityObjectCredentialType)PasswordCredential.TYPE)) {
            HibernateIdentityObjectCredentialType hibernateCredentialType = this.getHibernateIdentityObjectCredentialType(ctx, (IdentityObjectCredentialType)PasswordCredential.TYPE);
            if (hibernateCredentialType == null) {
                throw new IllegalStateException("Credential type not present in this store: " + PasswordCredential.TYPE.getName());
            }
            HibernateIdentityObjectCredential hibernateCredential = hibernateObject.getCredential((IdentityObjectCredentialType)PasswordCredential.TYPE);
            return hibernateCredential != null;
        }
        return false;
    }
}

