/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ExpressionAuthorizationDecision;

final class ExpressionUtils {
    private ExpressionUtils() {
    }

    static AuthorizationResult evaluate(Expression expr, EvaluationContext ctx) {
        try {
            Object result = expr.getValue(ctx);
            if (result instanceof AuthorizationResult) {
                AuthorizationResult decision = (AuthorizationResult)result;
                return decision;
            }
            if (result instanceof Boolean) {
                Boolean granted = (Boolean)result;
                return new ExpressionAuthorizationDecision(granted, expr);
            }
            if (result == null) {
                return null;
            }
            throw new IllegalArgumentException("SpEL expression must return either a Boolean or an AuthorizationDecision");
        }
        catch (EvaluationException ex) {
            AuthorizationDeniedException denied = ExpressionUtils.findAuthorizationException(ex);
            if (denied != null) {
                throw denied;
            }
            throw new IllegalArgumentException("Failed to evaluate expression '" + expr.getExpressionString() + "'", ex);
        }
    }

    static AuthorizationDeniedException findAuthorizationException(EvaluationException ex) {
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof AuthorizationDeniedException)) continue;
            AuthorizationDeniedException denied = (AuthorizationDeniedException)cause;
            return denied;
        }
        return null;
    }
}

