/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration;

import co.elastic.clients.elasticsearch.migration.post_feature_upgrade.MigrationFeature;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PostFeatureUpgradeResponse
implements JsonpSerializable {
    private final boolean accepted;
    private final List<MigrationFeature> features;
    public static final JsonpDeserializer<PostFeatureUpgradeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostFeatureUpgradeResponse::setupPostFeatureUpgradeResponseDeserializer);

    private PostFeatureUpgradeResponse(Builder builder) {
        this.accepted = ApiTypeHelper.requireNonNull(builder.accepted, (Object)this, "accepted", false);
        this.features = ApiTypeHelper.unmodifiableRequired(builder.features, (Object)this, "features");
    }

    public static PostFeatureUpgradeResponse of(Function<Builder, ObjectBuilder<PostFeatureUpgradeResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean accepted() {
        return this.accepted;
    }

    public final List<MigrationFeature> features() {
        return this.features;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("accepted");
        generator.write(this.accepted);
        if (ApiTypeHelper.isDefined(this.features)) {
            generator.writeKey("features");
            generator.writeStartArray();
            for (MigrationFeature item0 : this.features) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPostFeatureUpgradeResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accepted, JsonpDeserializer.booleanDeserializer(), "accepted");
        op.add(Builder::features, JsonpDeserializer.arrayDeserializer(MigrationFeature._DESERIALIZER), "features");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PostFeatureUpgradeResponse> {
        private Boolean accepted;
        private List<MigrationFeature> features;

        public final Builder accepted(boolean value) {
            this.accepted = value;
            return this;
        }

        public final Builder features(List<MigrationFeature> list) {
            this.features = Builder._listAddAll(this.features, list);
            return this;
        }

        public final Builder features(MigrationFeature value, MigrationFeature ... values) {
            this.features = Builder._listAdd(this.features, value, values);
            return this;
        }

        public final Builder features(Function<MigrationFeature.Builder, ObjectBuilder<MigrationFeature>> fn) {
            return this.features(fn.apply(new MigrationFeature.Builder()).build(), new MigrationFeature[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostFeatureUpgradeResponse build() {
            this._checkSingleUse();
            return new PostFeatureUpgradeResponse(this);
        }
    }
}

