/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.news.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.content.news.model.ArticleTarget;
import io.meeds.content.news.model.ContentPublishEvent;
import io.meeds.content.news.model.News;
import io.meeds.content.news.service.NewsTargetingService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
@Profile(value={"analytics"})
public class ContentPublishListener
extends Listener<String, ContentPublishEvent> {
    private static final String CREATE_PUBLISH_CONTENT = "createPublishContent";
    private static final String UPDATE_PUBLISH_CONTENT = "updatePublishContent";
    private static final String[] LISTENER_EVENTS = new String[]{"createPublishContent", "updatePublishContent"};
    private final SpaceService spaceService;
    private final ListenerService listenerService;
    private final IdentityManager identityManager;
    private final NewsTargetingService newsTargetingService;

    @Autowired
    public ContentPublishListener(SpaceService spaceService, ListenerService listenerService, IdentityManager identityManager, NewsTargetingService newsTargetingService) {
        this.spaceService = spaceService;
        this.listenerService = listenerService;
        this.identityManager = identityManager;
        this.newsTargetingService = newsTargetingService;
    }

    @PostConstruct
    public void init() {
        for (String listener : LISTENER_EVENTS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, ContentPublishEvent> event) throws Exception {
        String userName = (String)event.getSource();
        long userId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(userName).getId());
        News originalArticle = ((ContentPublishEvent)event.getData()).getOriginalArticle();
        News updatedArticle = ((ContentPublishEvent)event.getData()).getUpdatedArticle();
        if (event.getEventName().equals(CREATE_PUBLISH_CONTENT) && (updatedArticle.isActivityPosted() || updatedArticle.isPublished()) || this.isValidPublish(originalArticle, updatedArticle)) {
            this.addPublishContentStatistics(userId, updatedArticle);
        }
    }

    private void addPublishContentStatistics(long userId, News news) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("contents");
        statisticData.setSubModule("contents");
        statisticData.setOperation("publishContent");
        statisticData.setUserId(userId);
        statisticData.addParameter("contentId", (Object)news.getId());
        statisticData.addParameter("contentTitle", (Object)news.getTitle());
        statisticData.addParameter("contentType", (Object)"News");
        statisticData.addParameter("contentCreator", (Object)news.getAuthor());
        List<String> targets = this.toTargetNames(news);
        if (!targets.isEmpty()) {
            statisticData.addParameter("contentPublishingTargets", this.toTargetNames(news));
        }
        statisticData.addParameter("contentFeedPublishing", (Object)(news.isActivityPosted() ? "YES" : null));
        String scheduleDates = this.toScheduleDates(news);
        if (StringUtils.isNotBlank((CharSequence)scheduleDates)) {
            statisticData.addParameter("contentScheduling", (Object)scheduleDates);
        }
        statisticData.addParameter("contentHideAuthor", (Object)(news.getProperties().isHideAuthor() ? "YES" : "NO"));
        statisticData.addParameter("contentHideReaction", (Object)(news.getProperties().isHideReaction() ? "YES" : "NO"));
        statisticData.addParameter("contentUpdatedDate", (Object)(news.getUpdateDate() != null ? news.getUpdateDate() : news.getCreationDate()));
        this.processSpaceStatistics(statisticData, news);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private List<String> toTargetNames(News news) {
        List<ArticleTarget> targets = this.newsTargetingService.getTargetsByNews(news);
        if (CollectionUtils.isEmpty(targets)) {
            return new ArrayList<String>();
        }
        return targets.stream().map(ArticleTarget::getName).toList();
    }

    private String toScheduleDates(News news) {
        return Arrays.stream(new String[]{news.getSchedulePostDate(), news.getScheduleUnpublishDate()}).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    private boolean isValidPublish(News originalArticle, News updatedArticle) {
        return originalArticle.isPublished() != updatedArticle.isPublished() || originalArticle.isActivityPosted() != updatedArticle.isActivityPosted() || this.targetListUpdated(originalArticle.getTargets(), updatedArticle.getTargets()) || !this.toScheduleDates(originalArticle).equals(this.toScheduleDates(updatedArticle)) || this.isHideAuthorUpdated(originalArticle, updatedArticle) || this.isHideReactionUpdated(originalArticle, updatedArticle);
    }

    private boolean isHideReactionUpdated(News originalArticle, News updatedArticle) {
        if (originalArticle.getProperties() == null || updatedArticle.getProperties() == null) {
            return false;
        }
        return originalArticle.getProperties().isHideReaction() != updatedArticle.getProperties().isHideReaction();
    }

    private boolean isHideAuthorUpdated(News originalArticle, News updatedArticle) {
        if (originalArticle.getProperties() == null || updatedArticle.getProperties() == null) {
            return false;
        }
        return originalArticle.getProperties().isHideAuthor() != updatedArticle.getProperties().isHideAuthor();
    }

    private boolean targetListUpdated(List<ArticleTarget> targets, List<ArticleTarget> updatedTargets) {
        return !Objects.equals(this.extractTargetNames(targets), this.extractTargetNames(updatedTargets));
    }

    private Set<String> extractTargetNames(List<ArticleTarget> targets) {
        return targets == null ? Collections.emptySet() : targets.stream().map(ArticleTarget::getName).collect(Collectors.toSet());
    }

    private void processSpaceStatistics(StatisticData statisticData, News news) {
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        if (space != null) {
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
    }
}

