/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.DistanceUnit;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.Slices;
import co.elastic.clients.elasticsearch._types.SortMode;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch.core.search.BoundaryScanner;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.elasticsearch.core.search.HighlighterFragmenter;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import co.elastic.clients.elasticsearch.core.search.HighlighterTagsSchema;
import co.elastic.clients.elasticsearch.core.search.HighlighterType;
import co.elastic.clients.elasticsearch.core.search.ScoreMode;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.HasChildQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.query.types.ConflictsType;
import org.springframework.data.elasticsearch.core.query.types.OperatorType;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class TypeUtils {
    TypeUtils() {
    }

    @Nullable
    static BoundaryScanner boundaryScanner(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "chars" -> BoundaryScanner.Chars;
                case "sentence" -> BoundaryScanner.Sentence;
                case "word" -> BoundaryScanner.Word;
                default -> null;
            };
        }
        return null;
    }

    static Conflicts conflicts(ReindexRequest.Conflicts conflicts) {
        return switch (conflicts) {
            default -> throw new IncompatibleClassChangeError();
            case ReindexRequest.Conflicts.ABORT -> Conflicts.Abort;
            case ReindexRequest.Conflicts.PROCEED -> Conflicts.Proceed;
        };
    }

    @Nullable
    static DistanceUnit distanceUnit(String unit) {
        return switch (unit.toLowerCase()) {
            case "in", "inch" -> DistanceUnit.Inches;
            case "yd", "yards" -> DistanceUnit.Yards;
            case "ft", "feet" -> DistanceUnit.Feet;
            case "km", "kilometers" -> DistanceUnit.Kilometers;
            case "nm", "nmi" -> DistanceUnit.NauticMiles;
            case "mm", "millimeters" -> DistanceUnit.Millimeters;
            case "cm", "centimeters" -> DistanceUnit.Centimeters;
            case "mi", "miles" -> DistanceUnit.Miles;
            case "m", "meters" -> DistanceUnit.Meters;
            default -> null;
        };
    }

    @Nullable
    static FieldType fieldType(String type) {
        for (FieldType fieldType : FieldType.values()) {
            if (!fieldType.jsonValue().equals(type)) continue;
            return fieldType;
        }
        return null;
    }

    @Nullable
    static String toString(@Nullable FieldValue fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        switch (fieldValue._kind()) {
            case Double: {
                return String.valueOf(fieldValue.doubleValue());
            }
            case Long: {
                return String.valueOf(fieldValue.longValue());
            }
            case Boolean: {
                return String.valueOf(fieldValue.booleanValue());
            }
            case String: {
                return fieldValue.stringValue();
            }
            case Null: {
                return null;
            }
            case Any: {
                return fieldValue.anyValue().toString();
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(fieldValue._kind()));
    }

    @Nullable
    static Object toObject(@Nullable FieldValue fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        switch (fieldValue._kind()) {
            case Double: {
                return fieldValue.doubleValue();
            }
            case Long: {
                return fieldValue.longValue();
            }
            case Boolean: {
                return fieldValue.booleanValue();
            }
            case String: {
                return fieldValue.stringValue();
            }
            case Null: {
                return null;
            }
            case Any: {
                return fieldValue.anyValue().toString();
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(fieldValue._kind()));
    }

    @Nullable
    static FieldValue toFieldValue(@Nullable Object fieldValue) {
        if (fieldValue == null) {
            return FieldValue.NULL;
        }
        if (fieldValue instanceof Boolean) {
            Boolean b = (Boolean)fieldValue;
            return b != false ? FieldValue.TRUE : FieldValue.FALSE;
        }
        if (fieldValue instanceof String) {
            String s = (String)fieldValue;
            return FieldValue.of((String)s);
        }
        if (fieldValue instanceof Long) {
            Long l = (Long)fieldValue;
            return FieldValue.of((Object)l);
        }
        if (fieldValue instanceof Integer) {
            Integer i = (Integer)fieldValue;
            return FieldValue.of((long)i.intValue());
        }
        if (fieldValue instanceof Double) {
            Double d = (Double)fieldValue;
            return FieldValue.of((Object)d);
        }
        if (fieldValue instanceof Float) {
            Float f = (Float)fieldValue;
            return FieldValue.of((double)f.floatValue());
        }
        return FieldValue.of((JsonData)JsonData.of((Object)fieldValue));
    }

    @Nullable
    static GeoDistanceType geoDistanceType(GeoDistanceOrder.DistanceType distanceType) {
        return switch (distanceType) {
            default -> throw new IncompatibleClassChangeError();
            case GeoDistanceOrder.DistanceType.arc -> GeoDistanceType.Arc;
            case GeoDistanceOrder.DistanceType.plane -> GeoDistanceType.Plane;
        };
    }

    @Nullable
    static SortOrder sortOrder(@Nullable Sort.Direction direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Sort.Direction.ASC -> SortOrder.Asc;
            case Sort.Direction.DESC -> SortOrder.Desc;
        };
    }

    @Nullable
    static HighlighterFragmenter highlighterFragmenter(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "simple" -> HighlighterFragmenter.Simple;
                case "span" -> HighlighterFragmenter.Span;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    static HighlighterOrder highlighterOrder(@Nullable String value) {
        if (value != null && "score".equals(value.toLowerCase())) {
            return HighlighterOrder.Score;
        }
        return null;
    }

    @Nullable
    static HighlighterType highlighterType(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "unified" -> HighlighterType.Unified;
                case "plain" -> HighlighterType.Plain;
                case "fvh" -> HighlighterType.FastVector;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    static HighlighterEncoder highlighterEncoder(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "default" -> HighlighterEncoder.Default;
                case "html" -> HighlighterEncoder.Html;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    static HighlighterTagsSchema highlighterTagsSchema(@Nullable String value) {
        if (value != null && "styled".equals(value.toLowerCase())) {
            return HighlighterTagsSchema.Styled;
        }
        return null;
    }

    @Nullable
    static OpType opType(@Nullable IndexQuery.OpType opType) {
        if (opType != null) {
            return switch (opType) {
                default -> throw new IncompatibleClassChangeError();
                case IndexQuery.OpType.INDEX -> OpType.Index;
                case IndexQuery.OpType.CREATE -> OpType.Create;
            };
        }
        return null;
    }

    static Refresh refresh(@Nullable RefreshPolicy refreshPolicy) {
        if (refreshPolicy == null) {
            return Refresh.False;
        }
        return switch (refreshPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case RefreshPolicy.IMMEDIATE -> Refresh.True;
            case RefreshPolicy.WAIT_UNTIL -> Refresh.WaitFor;
            case RefreshPolicy.NONE -> Refresh.False;
        };
    }

    @Nullable
    static UpdateResponse.Result result(@Nullable Result result) {
        if (result == null) {
            return null;
        }
        return switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case Result.Created -> UpdateResponse.Result.CREATED;
            case Result.Updated -> UpdateResponse.Result.UPDATED;
            case Result.Deleted -> UpdateResponse.Result.DELETED;
            case Result.NotFound -> UpdateResponse.Result.NOT_FOUND;
            case Result.NoOp -> UpdateResponse.Result.NOOP;
        };
    }

    @Nullable
    static ScoreMode scoreMode(@Nullable RescorerQuery.ScoreMode scoreMode) {
        if (scoreMode == null) {
            return null;
        }
        return switch (scoreMode) {
            default -> throw new IncompatibleClassChangeError();
            case RescorerQuery.ScoreMode.Default -> null;
            case RescorerQuery.ScoreMode.Avg -> ScoreMode.Avg;
            case RescorerQuery.ScoreMode.Max -> ScoreMode.Max;
            case RescorerQuery.ScoreMode.Min -> ScoreMode.Min;
            case RescorerQuery.ScoreMode.Total -> ScoreMode.Total;
            case RescorerQuery.ScoreMode.Multiply -> ScoreMode.Multiply;
        };
    }

    @Nullable
    static SearchType searchType(@Nullable Query.SearchType searchType) {
        if (searchType == null) {
            return null;
        }
        return switch (searchType) {
            default -> throw new IncompatibleClassChangeError();
            case Query.SearchType.QUERY_THEN_FETCH -> SearchType.QueryThenFetch;
            case Query.SearchType.DFS_QUERY_THEN_FETCH -> SearchType.DfsQueryThenFetch;
        };
    }

    @Nullable
    static Slices slices(@Nullable Long count) {
        if (count == null) {
            return null;
        }
        return Slices.of(s -> s.value(Integer.valueOf(Math.toIntExact(count))));
    }

    @Nullable
    static SortMode sortMode(Order.Mode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Order.Mode.min -> SortMode.Min;
            case Order.Mode.max -> SortMode.Max;
            case Order.Mode.median -> SortMode.Median;
            case Order.Mode.avg -> SortMode.Avg;
        };
    }

    @Nullable
    static Time time(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return Time.of(t -> t.time(duration.toMillis() + "ms"));
    }

    @Nullable
    static String timeStringMs(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis() + "ms";
    }

    @Nullable
    static VersionType versionType(@Nullable Document.VersionType versionType) {
        if (versionType != null) {
            return switch (versionType) {
                default -> throw new IncompatibleClassChangeError();
                case Document.VersionType.INTERNAL -> VersionType.Internal;
                case Document.VersionType.EXTERNAL -> VersionType.External;
                case Document.VersionType.EXTERNAL_GTE -> VersionType.ExternalGte;
                case Document.VersionType.FORCE -> VersionType.Force;
            };
        }
        return null;
    }

    static Integer waitForActiveShardsCount(@Nullable String value) {
        if (value == null) {
            return -2;
        }
        if ("all".equals(value.toLowerCase())) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegale value for waitForActiveShards" + value);
        }
    }

    @Nullable
    static Float toFloat(@Nullable Long value) {
        return value != null ? Float.valueOf(value.longValue()) : null;
    }

    @Nullable
    public static List<ExpandWildcard> expandWildcards(@Nullable EnumSet<IndicesOptions.WildcardStates> wildcardStates) {
        return wildcardStates != null && !wildcardStates.isEmpty() ? wildcardStates.stream().map(wildcardState -> ExpandWildcard.valueOf((String)wildcardState.name().toLowerCase())).collect(Collectors.toList()) : null;
    }

    @Nullable
    static TypeMapping typeMapping(@Nullable Document mapping) {
        if (mapping != null) {
            return TypeMapping.of(b -> (ObjectBuilder)b.withJson((Reader)new StringReader(mapping.toJson())));
        }
        return null;
    }

    @Nullable
    static Document typeMapping(@Nullable TypeMapping typeMapping) {
        return typeMapping != null ? Document.parse(TypeUtils.removePrefixFromJson(typeMapping.toString())) : null;
    }

    public static String removePrefixFromJson(String jsonWithPrefix) {
        return jsonWithPrefix.substring(jsonWithPrefix.indexOf("{"));
    }

    @Nullable
    static IndexSettings indexSettings(@Nullable Map<String, Object> settings) {
        return settings != null ? IndexSettings.of(b -> (ObjectBuilder)b.withJson((Reader)new StringReader(Document.from(settings).toJson()))) : null;
    }

    static Map<String, JsonData> paramsMap(Map<String, Object> params) {
        Assert.notNull(params, (String)"params must not be null");
        LinkedHashMap<String, JsonData> mappedParams = new LinkedHashMap<String, JsonData>();
        params.forEach((key, value) -> mappedParams.put((String)key, JsonData.of((Object)value)));
        return mappedParams;
    }

    @Nullable
    static Operator operator(@Nullable OperatorType operator) {
        return operator != null ? Operator.valueOf((String)operator.name()) : null;
    }

    @Nullable
    static Conflicts conflicts(@Nullable ConflictsType conflicts) {
        return conflicts != null ? Conflicts.valueOf((String)conflicts.name()) : null;
    }

    static ChildScoreMode scoreMode(@Nullable HasChildQuery.ScoreMode scoreMode) {
        if (scoreMode == null) {
            return ChildScoreMode.None;
        }
        return switch (scoreMode) {
            case HasChildQuery.ScoreMode.Avg -> ChildScoreMode.Avg;
            case HasChildQuery.ScoreMode.Max -> ChildScoreMode.Max;
            case HasChildQuery.ScoreMode.Min -> ChildScoreMode.Min;
            case HasChildQuery.ScoreMode.Sum -> ChildScoreMode.Sum;
            default -> ChildScoreMode.None;
        };
    }
}

