/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.Arrays;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationHook;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.aot.AbstractAotProcessor;
import org.springframework.context.aot.ContextAotProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.ThrowingSupplier;

public class SpringApplicationAotProcessor
extends ContextAotProcessor {
    private final String[] applicationArgs;

    public SpringApplicationAotProcessor(Class<?> application, AbstractAotProcessor.Settings settings, String[] applicationArgs) {
        super(application, settings);
        this.applicationArgs = applicationArgs;
    }

    protected GenericApplicationContext prepareApplicationContext(Class<?> application) {
        return new AotProcessorHook(application).run(() -> {
            Method mainMethod = application.getMethod("main", String[].class);
            return ReflectionUtils.invokeMethod((Method)mainMethod, null, (Object[])new Object[]{this.applicationArgs});
        });
    }

    public static void main(String[] args) throws Exception {
        int requiredArgs = 6;
        Assert.state((args.length >= requiredArgs ? 1 : 0) != 0, () -> "Usage: " + SpringApplicationAotProcessor.class.getName() + " <applicationMainClass> <sourceOutput> <resourceOutput> <classOutput> <groupId> <artifactId> <originalArgs...>");
        Class<?> application = Class.forName(args[0]);
        AbstractAotProcessor.Settings settings = AbstractAotProcessor.Settings.builder().sourceOutput(Paths.get(args[1], new String[0])).resourceOutput(Paths.get(args[2], new String[0])).classOutput(Paths.get(args[3], new String[0])).groupId(StringUtils.hasText((String)args[4]) ? args[4] : "unspecified").artifactId(args[5]).build();
        String[] applicationArgs = args.length > requiredArgs ? Arrays.copyOfRange(args, requiredArgs, args.length) : new String[]{};
        new SpringApplicationAotProcessor(application, settings, applicationArgs).process();
    }

    private static final class AotProcessorHook
    implements SpringApplicationHook {
        private final Class<?> application;

        private AotProcessorHook(Class<?> application) {
            this.application = application;
        }

        @Override
        public SpringApplicationRunListener getRunListener(SpringApplication application) {
            return new SpringApplicationRunListener(){

                @Override
                public void contextLoaded(ConfigurableApplicationContext context) {
                    throw new SpringApplication.AbandonedRunException(context);
                }
            };
        }

        private <T> GenericApplicationContext run(ThrowingSupplier<T> action) {
            try {
                SpringApplication.withHook((SpringApplicationHook)this, action);
            }
            catch (SpringApplication.AbandonedRunException ex) {
                ConfigurableApplicationContext context = ex.getApplicationContext();
                Assert.state((boolean)(context instanceof GenericApplicationContext), () -> AotProcessorHook.lambda$run$0((ApplicationContext)context));
                return (GenericApplicationContext)context;
            }
            throw new IllegalStateException("No application context available after calling main method of '%s'. Does it run a SpringApplication?".formatted(this.application.getName()));
        }

        private static /* synthetic */ String lambda$run$0(ApplicationContext context) {
            return "AOT processing requires a GenericApplicationContext but got a " + context.getClass().getName();
        }
    }
}

