/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.http.client.HttpClientAutoConfiguration;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.autoconfigure.web.client.AutoConfiguredRestClientSsl;
import org.springframework.boot.autoconfigure.web.client.HttpMessageConvertersRestClientCustomizer;
import org.springframework.boot.autoconfigure.web.client.NotReactiveWebApplicationOrVirtualThreadsExecutorEnabledCondition;
import org.springframework.boot.autoconfigure.web.client.RestClientBuilderConfigurer;
import org.springframework.boot.autoconfigure.web.client.RestClientSsl;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={HttpClientAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, SslAutoConfiguration.class, TaskExecutionAutoConfiguration.class})
@ConditionalOnClass(value={RestClient.class})
@Conditional(value={NotReactiveWebApplicationOrVirtualThreadsExecutorEnabledCondition.class})
public class RestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Order(value=0x7FFFFFFF)
    HttpMessageConvertersRestClientCustomizer httpMessageConvertersRestClientCustomizer(ObjectProvider<HttpMessageConverters> messageConverters) {
        return new HttpMessageConvertersRestClientCustomizer((HttpMessageConverters)messageConverters.getIfUnique());
    }

    @Bean
    @ConditionalOnMissingBean(value={RestClientSsl.class})
    @ConditionalOnBean(value={SslBundles.class})
    AutoConfiguredRestClientSsl restClientSsl(ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> clientHttpRequestFactorySettings, SslBundles sslBundles) {
        return new AutoConfiguredRestClientSsl((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable(ClientHttpRequestFactoryBuilder::detect), (ClientHttpRequestFactorySettings)clientHttpRequestFactorySettings.getIfAvailable(ClientHttpRequestFactorySettings::defaults), sslBundles);
    }

    @Bean
    @ConditionalOnMissingBean
    RestClientBuilderConfigurer restClientBuilderConfigurer(ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> clientHttpRequestFactorySettings, ObjectProvider<RestClientCustomizer> customizerProvider) {
        return new RestClientBuilderConfigurer((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable(ClientHttpRequestFactoryBuilder::detect), (ClientHttpRequestFactorySettings)clientHttpRequestFactorySettings.getIfAvailable(ClientHttpRequestFactorySettings::defaults), customizerProvider.orderedStream().toList());
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    RestClient.Builder restClientBuilder(RestClientBuilderConfigurer restClientBuilderConfigurer) {
        return restClientBuilderConfigurer.configure(RestClient.builder());
    }
}

