/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.util.Locale;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;

public enum CacheMode {
    NORMAL(CacheStoreMode.USE, CacheRetrieveMode.USE),
    IGNORE(CacheStoreMode.BYPASS, CacheRetrieveMode.BYPASS),
    GET(CacheStoreMode.BYPASS, CacheRetrieveMode.USE),
    PUT(CacheStoreMode.USE, CacheRetrieveMode.BYPASS),
    REFRESH(CacheStoreMode.REFRESH, CacheRetrieveMode.BYPASS);

    private final CacheStoreMode storeMode;
    private final CacheRetrieveMode retrieveMode;

    private CacheMode(CacheStoreMode storeMode, CacheRetrieveMode retrieveMode) {
        this.storeMode = storeMode;
        this.retrieveMode = retrieveMode;
    }

    public CacheStoreMode getJpaStoreMode() {
        return this.storeMode;
    }

    public CacheRetrieveMode getJpaRetrieveMode() {
        return this.retrieveMode;
    }

    public boolean isGetEnabled() {
        return this.retrieveMode == CacheRetrieveMode.USE;
    }

    public boolean isPutEnabled() {
        return this.storeMode == CacheStoreMode.USE || this.storeMode == CacheStoreMode.REFRESH;
    }

    public static CacheMode interpretExternalSetting(String setting) {
        if (setting == null) {
            return null;
        }
        try {
            return CacheMode.valueOf(setting.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new MappingException("Unknown Cache Mode: " + setting);
        }
    }

    public static CacheMode fromJpaModes(CacheRetrieveMode retrieveMode, CacheStoreMode storeMode) {
        if (retrieveMode == null && storeMode == null) {
            return null;
        }
        if (storeMode == null) {
            storeMode = CacheStoreMode.BYPASS;
        }
        if (retrieveMode == null) {
            retrieveMode = CacheRetrieveMode.BYPASS;
        }
        switch (storeMode) {
            case USE: {
                switch (retrieveMode) {
                    case USE: {
                        return NORMAL;
                    }
                    case BYPASS: {
                        return PUT;
                    }
                }
            }
            case BYPASS: {
                switch (retrieveMode) {
                    case USE: {
                        return GET;
                    }
                    case BYPASS: {
                        return IGNORE;
                    }
                }
            }
            case REFRESH: {
                return REFRESH;
            }
        }
        throw new AssertionFailure("Unrecognized CacheStoreMode: " + String.valueOf(storeMode));
    }
}

