/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterOutOfBoundsException;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public abstract class Parameters<S extends Parameters<S, T>, T extends Parameter>
implements Streamable<T> {
    public static final List<Class<?>> TYPES = List.of(ScrollPosition.class, Pageable.class, Sort.class, Limit.class);
    private static final String PARAM_ON_SPECIAL = String.format("You must not use @%s on a parameter typed %s or %s", Param.class.getSimpleName(), Pageable.class.getSimpleName(), Sort.class.getSimpleName());
    private static final String ALL_OR_NOTHING = String.format("Either use @%s on all parameters except %s and %s typed once, or none at all", Param.class.getSimpleName(), Pageable.class.getSimpleName(), Sort.class.getSimpleName());
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final int scrollPositionIndex;
    private final int pageableIndex;
    private final int sortIndex;
    private final int limitIndex;
    private final List<T> parameters;
    private final Lazy<S> bindable;
    private int dynamicProjectionIndex;

    @Deprecated(since="3.2.1", forRemoval=true)
    protected Parameters(Method method, Function<MethodParameter, T> parameterFactory) {
        this(ParametersSource.of(method), parameterFactory);
    }

    protected Parameters(ParametersSource parametersSource, Function<MethodParameter, T> parameterFactory) {
        Assert.notNull((Object)parametersSource, (String)"ParametersSource must not be null");
        Assert.notNull(parameterFactory, (String)"Parameter factory must not be null");
        Method method = parametersSource.getMethod();
        int parameterCount = method.getParameterCount();
        this.parameters = new ArrayList<T>(parameterCount);
        this.dynamicProjectionIndex = -1;
        int scrollPositionIndex = -1;
        int pageableIndex = -1;
        int sortIndex = -1;
        int limitIndex = -1;
        for (int i = 0; i < parameterCount; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i).withContainingClass(parametersSource.getContainingClass());
            methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
            Parameter parameter = (Parameter)parameterFactory.apply(methodParameter);
            if (parameter.isSpecialParameter() && parameter.isNamedParameter()) {
                throw new IllegalArgumentException(PARAM_ON_SPECIAL);
            }
            if (parameter.isDynamicProjectionParameter()) {
                this.dynamicProjectionIndex = parameter.getIndex();
            }
            if (ScrollPosition.class.isAssignableFrom(parameter.getType())) {
                scrollPositionIndex = i;
            }
            if (Pageable.class.isAssignableFrom(parameter.getType())) {
                pageableIndex = i;
            }
            if (Sort.class.isAssignableFrom(parameter.getType())) {
                sortIndex = i;
            }
            if (Limit.class.isAssignableFrom(parameter.getType())) {
                limitIndex = i;
            }
            this.parameters.add(parameter);
        }
        this.scrollPositionIndex = scrollPositionIndex;
        this.pageableIndex = pageableIndex;
        this.sortIndex = sortIndex;
        this.limitIndex = limitIndex;
        this.bindable = Lazy.of(this::getBindable);
        this.assertEitherAllParamAnnotatedOrNone();
    }

    protected Parameters(List<T> originals) {
        this.parameters = new ArrayList<T>(originals.size());
        int scrollPositionIndexTemp = -1;
        int pageableIndexTemp = -1;
        int sortIndexTemp = -1;
        int limitIndexTmp = -1;
        int dynamicProjectionTemp = -1;
        for (int i = 0; i < originals.size(); ++i) {
            Parameter original = (Parameter)originals.get(i);
            this.parameters.add(original);
            scrollPositionIndexTemp = original.isScrollPosition() ? i : -1;
            pageableIndexTemp = original.isPageable() ? i : -1;
            sortIndexTemp = original.isSort() ? i : -1;
            limitIndexTmp = original.isLimit() ? i : -1;
            dynamicProjectionTemp = original.isDynamicProjectionParameter() ? i : -1;
        }
        this.scrollPositionIndex = scrollPositionIndexTemp;
        this.pageableIndex = pageableIndexTemp;
        this.sortIndex = sortIndexTemp;
        this.limitIndex = limitIndexTmp;
        this.dynamicProjectionIndex = dynamicProjectionTemp;
        this.bindable = Lazy.of(() -> this);
    }

    private S getBindable() {
        ArrayList<Parameter> bindables = new ArrayList<Parameter>();
        for (Parameter candidate : this) {
            if (!candidate.isBindable()) continue;
            bindables.add(candidate);
        }
        return this.createFrom(bindables);
    }

    public boolean hasScrollPositionParameter() {
        return this.scrollPositionIndex != -1;
    }

    public int getScrollPositionIndex() {
        return this.scrollPositionIndex;
    }

    public boolean hasPageableParameter() {
        return this.pageableIndex != -1;
    }

    public int getPageableIndex() {
        return this.pageableIndex;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public boolean hasSortParameter() {
        return this.sortIndex != -1;
    }

    public boolean hasLimitParameter() {
        return this.getLimitIndex() != -1;
    }

    public int getLimitIndex() {
        return this.limitIndex;
    }

    public int getDynamicProjectionIndex() {
        return this.dynamicProjectionIndex;
    }

    public boolean hasDynamicProjection() {
        return this.dynamicProjectionIndex != -1;
    }

    public boolean potentiallySortsDynamically() {
        return this.hasSortParameter() || this.hasPageableParameter();
    }

    public T getParameter(int index) {
        try {
            return (T)((Parameter)this.parameters.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParameterOutOfBoundsException("Invalid parameter index; You seem to have declared too little query method parameters", e);
        }
    }

    public boolean hasParameterAt(int position) {
        try {
            return null != this.getParameter(position);
        }
        catch (ParameterOutOfBoundsException e) {
            return false;
        }
    }

    public boolean hasSpecialParameter() {
        return this.hasScrollPositionParameter() || this.hasSortParameter() || this.hasPageableParameter();
    }

    public int getNumberOfParameters() {
        return this.parameters.size();
    }

    public S getBindableParameters() {
        return (S)((Parameters)this.bindable.get());
    }

    protected abstract S createFrom(List<T> var1);

    public T getBindableParameter(int bindableIndex) {
        return ((Parameters)this.getBindableParameters()).getParameter(bindableIndex);
    }

    private void assertEitherAllParamAnnotatedOrNone() {
        boolean nameFound = false;
        int index = 0;
        for (Parameter parameter : this.getBindableParameters()) {
            if (parameter.isNamedParameter()) {
                Assert.isTrue((nameFound || index == 0 ? 1 : 0) != 0, (String)ALL_OR_NOTHING);
                nameFound = true;
            } else {
                Assert.isTrue((!nameFound ? 1 : 0) != 0, (String)ALL_OR_NOTHING);
            }
            ++index;
        }
    }

    public static boolean isBindable(Class<?> type) {
        return !TYPES.contains(type);
    }

    @Override
    public Iterator<T> iterator() {
        return this.parameters.iterator();
    }
}

