/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.content.link.rest.util;

import io.meeds.content.link.model.Link;
import io.meeds.content.link.model.LinkSetting;
import io.meeds.content.link.model.LinkWithIconAttachment;
import io.meeds.content.link.rest.model.LinkRestEntity;
import io.meeds.content.link.rest.model.LinkSettingRestEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LinkEntityBuilder {
    private LinkEntityBuilder() {
    }

    public static LinkSettingRestEntity build(LinkSetting linkSetting, List<Link> links) {
        return new LinkSettingRestEntity(linkSetting.getId(), linkSetting.getName(), linkSetting.getHeader(), linkSetting.getType(), linkSetting.getVAlign(), linkSetting.getHAlign(), linkSetting.isLargeIcon(), linkSetting.getIconSize(), linkSetting.isShowName(), linkSetting.isShowIcon(), linkSetting.isShowDescription(), linkSetting.getSeeMore(), CollectionUtils.isEmpty(links) ? Collections.emptyList() : links.stream().map(l -> LinkEntityBuilder.build(linkSetting, l)).toList());
    }

    public static LinkRestEntity build(LinkSetting linkSetting, Link link) {
        return new LinkRestEntity(link.getId(), link.getName(), link.getDescription(), link.getUrl(), link.getIcon(), link.isSameTab(), link.getOrder(), LinkEntityBuilder.buildLinkIconUrl(linkSetting, link), link.getIconFileId(), null);
    }

    public static String buildLinkIconUrl(LinkSetting linkSetting, Link link) {
        if (link.getIconFileId() == 0L) {
            return null;
        }
        return "/content/rest/links/" + linkSetting.getName() + "/" + link.getId() + "/icon?v=" + Objects.hash(linkSetting.getLastModified());
    }

    public static LinkSetting toLinkSetting(LinkSettingRestEntity linkSettingEntity) {
        return new LinkSetting(linkSettingEntity.getId(), linkSettingEntity.getName(), null, 0L, linkSettingEntity.getHeader(), linkSettingEntity.getType(), linkSettingEntity.getVAlign(), linkSettingEntity.getHAlign(), linkSettingEntity.isLargeIcon(), linkSettingEntity.getIconSize(), linkSettingEntity.isShowName(), linkSettingEntity.isShowIcon(), linkSettingEntity.isShowDescription(), linkSettingEntity.getSeeMore(), 0L);
    }

    public static List<Link> toLinks(LinkSettingRestEntity linkSettingEntity) {
        List<LinkRestEntity> links = linkSettingEntity.getLinks();
        return CollectionUtils.isEmpty(links) ? Collections.emptyList() : links.stream().map(l -> LinkEntityBuilder.toLink(l)).toList();
    }

    public static Link toLink(LinkRestEntity linkEntity) {
        if (StringUtils.isBlank((CharSequence)linkEntity.getIconUploadId())) {
            return new Link(linkEntity.getId(), linkEntity.getName(), linkEntity.getDescription(), linkEntity.getUrl(), linkEntity.getIcon(), linkEntity.isSameTab(), linkEntity.getOrder(), linkEntity.getIconFileId());
        }
        return new LinkWithIconAttachment(linkEntity.getId(), linkEntity.getName(), linkEntity.getDescription(), linkEntity.getUrl(), linkEntity.getIcon(), linkEntity.isSameTab(), linkEntity.getOrder(), linkEntity.getIconFileId(), linkEntity.getIconUploadId());
    }
}

