/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SqlQuery {
    @Nullable
    private final Boolean allowPartialSearchResults;
    @Nullable
    private final String catalog;
    @Nullable
    private final Boolean columnar;
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer fetchSize;
    @Nullable
    private final Boolean fieldMultiValueLeniency;
    @Nullable
    private final Query filter;
    @Nullable
    private final Boolean indexIncludeFrozen;
    @Nullable
    private final Duration keepAlive;
    @Nullable
    private final Boolean keepOnCompletion;
    @Nullable
    private final Duration pageTimeout;
    @Nullable
    private final Duration requestTimeout;
    @Nullable
    private final List<Object> params;
    private final String query;
    @Nullable
    private final TimeZone timeZone;
    @Nullable
    private final Duration waitForCompletionTimeout;

    private SqlQuery(Builder builder) {
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.catalog = builder.catalog;
        this.columnar = builder.columnar;
        this.cursor = builder.cursor;
        this.fetchSize = builder.fetchSize;
        this.fieldMultiValueLeniency = builder.fieldMultiValueLeniency;
        this.filter = builder.filter;
        this.indexIncludeFrozen = builder.indexIncludeFrozen;
        this.keepAlive = builder.keepAlive;
        this.keepOnCompletion = builder.keepOnCompletion;
        this.pageTimeout = builder.pageTimeout;
        this.requestTimeout = builder.requestTimeout;
        this.params = builder.params;
        this.query = builder.query;
        this.timeZone = builder.timeZone;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    @Nullable
    public Boolean getAllowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Nullable
    public String getCatalog() {
        return this.catalog;
    }

    @Nullable
    public Boolean getColumnar() {
        return this.columnar;
    }

    @Nullable
    public String getCursor() {
        return this.cursor;
    }

    @Nullable
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Nullable
    public Boolean getFieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    @Nullable
    public Query getFilter() {
        return this.filter;
    }

    @Nullable
    public Boolean getIndexIncludeFrozen() {
        return this.indexIncludeFrozen;
    }

    @Nullable
    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public Boolean getKeepOnCompletion() {
        return this.keepOnCompletion;
    }

    @Nullable
    public Duration getPageTimeout() {
        return this.pageTimeout;
    }

    @Nullable
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Nullable
    public List<Object> getParams() {
        return this.params;
    }

    public String getQuery() {
        return this.query;
    }

    @Nullable
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Nullable
    public Duration getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public static Builder builder(String query) {
        return new Builder(query);
    }

    public static class Builder {
        @Nullable
        private Boolean allowPartialSearchResults;
        @Nullable
        private String catalog;
        @Nullable
        private Boolean columnar;
        @Nullable
        private String cursor;
        @Nullable
        private Integer fetchSize;
        @Nullable
        private Boolean fieldMultiValueLeniency;
        @Nullable
        private Query filter;
        @Nullable
        private Boolean indexIncludeFrozen;
        @Nullable
        private Duration keepAlive;
        @Nullable
        private Boolean keepOnCompletion;
        @Nullable
        private Duration pageTimeout;
        @Nullable
        private Duration requestTimeout;
        @Nullable
        private List<Object> params;
        private final String query;
        @Nullable
        private TimeZone timeZone;
        @Nullable
        private Duration waitForCompletionTimeout;

        private Builder(String query) {
            Assert.notNull((Object)query, (String)"query must not be null");
            this.query = query;
        }

        public Builder withAllowPartialSearchResults(Boolean allowPartialSearchResults) {
            this.allowPartialSearchResults = allowPartialSearchResults;
            return this;
        }

        public Builder withCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder withColumnar(Boolean columnar) {
            this.columnar = columnar;
            return this;
        }

        public Builder withCursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder withFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder withFieldMultiValueLeniency(Boolean fieldMultiValueLeniency) {
            this.fieldMultiValueLeniency = fieldMultiValueLeniency;
            return this;
        }

        public Builder setFilter(Query filter) {
            this.filter = filter;
            return this;
        }

        public Builder withIndexIncludeFrozen(Boolean indexIncludeFrozen) {
            this.indexIncludeFrozen = indexIncludeFrozen;
            return this;
        }

        public Builder setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder withKeepOnCompletion(Boolean keepOnCompletion) {
            this.keepOnCompletion = keepOnCompletion;
            return this;
        }

        public Builder withPageTimeout(Duration pageTimeout) {
            this.pageTimeout = pageTimeout;
            return this;
        }

        public Builder withRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder withParams(List<Object> params) {
            this.params = params;
            return this;
        }

        public Builder withParam(Object param) {
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(param);
            return this;
        }

        public Builder withTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder withWaitForCompletionTimeout(Duration waitForCompletionTimeout) {
            this.waitForCompletionTimeout = waitForCompletionTimeout;
            return this;
        }

        public SqlQuery build() {
            return new SqlQuery(this);
        }
    }
}

